package com.biz.crm.mqlog.req;

import com.biz.crm.mq.mqlog.MdmMqMessageLogEs;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;


@Data
public class MqLogQueryReq extends MdmMqMessageLogEs {
    @ApiModelProperty("页码")
    private Integer pageNum = 1;

    @ApiModelProperty("每页长度")
    private Integer pageSize = 15;




    /**
     *
     * @return
     */
    public NativeSearchQuery buildQuery(){
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        //设置模糊搜索
        if(StringUtils.isNotBlank(this.getTopicAndTags())){
            builder.must(QueryBuilders.matchPhraseQuery("topicAndTags", this.getTopicAndTags()));
        }

        //设置模糊搜索
        if(StringUtils.isNotBlank(this.getBizKey())){
            builder.must(QueryBuilders.matchPhraseQuery("bizKey", this.getBizKey()));
        }
        //设置模糊搜索
        if(StringUtils.isNotBlank(this.getMsgBody())){
            builder.must(QueryBuilders.matchPhraseQuery("msgBody", this.getMsgBody()));
        }

        if(StringUtils.isNotBlank(this.getSendLog())){
            builder.must(QueryBuilders.matchPhraseQuery("sendLog", this.getSendLog()));
        }
        if(StringUtils.isNotBlank(this.getCallbackLog())){
            builder.must(QueryBuilders.matchPhraseQuery("callbackLog", this.getCallbackLog()));
        }
        if(StringUtils.isNotBlank(this.getCallbackBegin())){
            builder.must(QueryBuilders.matchPhraseQuery("callbackBegin", this.getCallbackBegin()));
        }
        if(StringUtils.isNotBlank(this.getCallbackEnd())){
            builder.must(QueryBuilders.matchPhraseQuery("callbackEnd", this.getCallbackEnd()));
        }

        if(StringUtils.isNotBlank(this.getSendStatus())){
            builder.must(QueryBuilders.matchPhraseQuery("sendStatus", this.getSendStatus()));
        }
        if(StringUtils.isNotBlank(this.getEndStatus())){
            builder.must(QueryBuilders.matchPhraseQuery("endStatus", this.getEndStatus()));
        }
        if(StringUtils.isNotBlank(this.getUpdateDateAll())){
            builder.must(QueryBuilders.matchPhraseQuery("updateDateAll", this.getUpdateDateAll()));
        }
        if(StringUtils.isNotBlank(this.getCreateDateAll())){
            builder.must(QueryBuilders.matchPhraseQuery("createDateAll", this.getCreateDateAll()));
        }
        if(StringUtils.isNotBlank(this.getCreateDate())){
            builder.must(QueryBuilders.matchPhraseQuery("createDate", this.getCreateDate()));
        }
        if(StringUtils.isNotBlank(this.getCreateDateSecond())){
            builder.must(QueryBuilders.matchPhraseQuery("createDateSecond", this.getCreateDateSecond()));
        }
        if(StringUtils.isNotBlank(this.getUpdateDateSecond())){
            builder.must(QueryBuilders.matchPhraseQuery("updateDateSecond", this.getUpdateDateSecond()));
        }
        if(StringUtils.isNotBlank(this.getUpdateDate())){
            builder.must(QueryBuilders.matchPhraseQuery("updateDate", this.getUpdateDate()));
        }
        if(StringUtils.isNotBlank(this.getMsgId())){
            builder.must(QueryBuilders.matchPhraseQuery("msgId", this.getMsgId()));
        }

        //构建查询
        NativeSearchQueryBuilder nativeSearchQueryBuilder = new NativeSearchQueryBuilder();
        //将搜索条件设置到构建中
        nativeSearchQueryBuilder.withQuery(builder);
        //设置分页
        //====注意!es的分页和Hibernate一样api是从第0页开始的=========
        nativeSearchQueryBuilder.withPageable(PageRequest.of(this.getPageNum() - 1, this.getPageSize()));
        //排序
//        nativeSearchQueryBuilder.withSort(SortBuilders.fieldSort("visitDate").order(SortOrder.DESC));
        //生产NativeSearchQuery
        NativeSearchQuery query = nativeSearchQueryBuilder.build();
        return query;
    }
}
