package com.biz.crm.newhope.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.nebular.mdm.newhope.req.NewHopeReqVo;
import com.biz.crm.newhope.service.OrgSyncService;
import com.biz.crm.newhope.util.Body;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.SneakyThrows;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author maoshen
 * @date 2021/6/3.
 */
@RequestMapping("orgSyncController")
@RestController
@Api(tags = "组织同步")
public class OrgSyncController {

    @Autowired
    private OrgSyncService orgSyncService;

    @SneakyThrows
    @PostMapping("/orgSyncwithCookie")
    @ApiOperation("组织同步(带cookie）")
    @CrmLog
    public Result<Body> orgSyncWithCookie(@RequestBody NewHopeReqVo reqVo) {
        Body body = orgSyncService.orgSyncWithCookie(reqVo);
        return Result.ok(body);
    }

    @SneakyThrows
    @PostMapping("/orgSyncAll")
    @ApiOperation("组织同步（全量同步）")
    @CrmLog
    public Result orgSyncAll(@RequestBody NewHopeReqVo reqVo) {
        orgSyncService.orgSyncAll(reqVo);
        return Result.ok("组织数据同步成功");
    }


    @SneakyThrows
    @PostMapping("/orgSyncIncrement")
    @ApiOperation("组织同步(增量同步）")
    @CrmLog
    public Result orgSyncIncrement(@RequestBody NewHopeReqVo reqVo) {
        orgSyncService.orgSyncIncrement(reqVo);
        return Result.ok("组织数据同步成功");
    }
}
