package com.biz.crm.newhope.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.nebular.mdm.newhope.req.NewHopeReqVo;
import com.biz.crm.newhope.service.UserSyncService;
import com.biz.crm.newhope.util.Body;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.SneakyThrows;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author maoshen
 * @date 2021/6/3.
 */
@RestController
@RequestMapping("/userSyncController")
@Slf4j
@Api(tags = "用户同步")
public class UserSyncController {

    @Autowired
    private UserSyncService userSyncService;


    @SneakyThrows
    @PostMapping("/userSyncWithCookie")
    @ApiOperation("/用户同步(带cookie)")
    @CrmLog
    public Result<Body> userSyncWithCookie(@RequestBody NewHopeReqVo reqVo) {
        Body body = userSyncService.userSyncWithCookie(reqVo);
        return Result.ok(body);
    }

    @SneakyThrows
    @PostMapping("/userSync")
    @ApiOperation("/用户同步 全量")
    @CrmLog
    public Result userSync(@RequestBody NewHopeReqVo reqVo) {
        userSyncService.userSync(reqVo);
        return Result.ok("操作成功");
    }

    @SneakyThrows
    @PostMapping("/userSyncIncrement")
    @ApiOperation("/用户同步 增量")
    @CrmLog
    public Result userSyncIncrement(@RequestBody NewHopeReqVo reqVo) {
        userSyncService.userSyncIncrement(reqVo);
        return Result.ok("操作成功");
    }
}
