package com.biz.crm.newhope.service;

import com.biz.crm.nebular.mdm.newhope.req.NewHopeReqVo;
import com.biz.crm.newhope.util.Body;

import java.io.UnsupportedEncodingException;

/**
 * @author maoshen
 * @date 2021/6/3.
 */
public interface UserSyncService {
    /**
     * 用户同步
     * 带cookie
     *
     * @param reqVo
     * @return
     */
    Body userSyncWithCookie(NewHopeReqVo reqVo) throws UnsupportedEncodingException;

    /**
     * 用户同步
     * 全量
     *
     * @param reqVo
     * @return
     * @throws UnsupportedEncodingException
     */
    void userSync(NewHopeReqVo reqVo) throws UnsupportedEncodingException;

    /**
     * 用户同步
     * 增量
     *
     * @param reqVo
     * @throws UnsupportedEncodingException
     */
    void userSyncIncrement(NewHopeReqVo reqVo) throws UnsupportedEncodingException;
}
