package com.biz.crm.notice.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeCommentRespVo;
import com.biz.crm.notice.model.MdmNoticeCommentEntity;
import com.biz.crm.notice.model.MdmNoticeCommentLikesEntity;
import com.biz.crm.util.Result;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 公告评论点赞
 *
 * @author yangshan
 * @date 2021-2-5 19:30:32
 */
public interface MdmNoticeCommentLikesMapper extends BaseMapper<MdmNoticeCommentLikesEntity> {

    /**
     * 统计评论的点赞数
     *
     * @param commentId commentId
     * @return
     */
    Integer getTotalCommentLikes(String commentId);

    /**
     * 根据评论id删除对应点赞
     * @param commentIds
     */
    void deleteProductCommentIds(@Param("commentIds") List<String> commentIds);
}
