package com.biz.crm.notice.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeCommentReqVo;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeCommentRespVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeRespVo;
import com.biz.crm.notice.model.MdmNoticeCommentEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 公告评论
 *
 * @author yangshan
 * @date 2021-2-4 11:46:22
 */
public interface MdmNoticeCommentMapper extends BaseMapper<MdmNoticeCommentEntity> {

    /**
     * 查询公告对应评论
     *
     * @param page
     * @param mdmNoticeCommentReqVo
     * @return
     */
    List<MdmNoticeCommentRespVo> findCommentList(Page<MdmNoticeCommentRespVo> page, @Param("vo") MdmNoticeCommentReqVo mdmNoticeCommentReqVo);

    /**
     * 根据公告id批量删除评论
     * @param noticeIds
     */
    void deleteProductsByNoticeIds(@Param("noticeIds") List<String> noticeIds);

    /**
     * 通过公告id查询出对应评论id
     * @param noticeIds
     * @return
     */
    List<String> selectCommentIds(@Param("noticeIds") List<String> noticeIds);
}
