package com.biz.crm.notice.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeFileReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeFileRespVo;
import com.biz.crm.notice.model.MdmNoticeFileEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 公告附件 
 * 
 * @author liuhongming
 * @date 2020-09-17 17:14:43
 */
public interface MdmNoticeFileMapper extends BaseMapper<MdmNoticeFileEntity> {
    /**
     * 列表
     * @param page
     * @param mdmNoticeFileReqVo
     * @return
     */
    List<MdmNoticeFileRespVo> findList(Page<MdmNoticeFileRespVo> page, @Param("vo") MdmNoticeFileReqVo mdmNoticeFileReqVo);

    /**
     * 删除
     * @param mdmNoticeFileReqVo
     */
    void deleteProductsByParams(@Param("vo") MdmNoticeFileReqVo mdmNoticeFileReqVo);

    /**
     * 根据公告查附件集合
     * @param noticeCode
     * @return
     */
    List<MdmNoticeFileRespVo> findMiniList(String noticeCode);
}
