package com.biz.crm.notice.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeMiniReqVo;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeRespVo;
import com.biz.crm.notice.model.MdmNoticeEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 公告管理 
 * 
 * @author liuhongming
 * @date 2020-09-17 17:14:42
 */
public interface MdmNoticeMapper extends BaseMapper<MdmNoticeEntity> {
    /**
     * 列表
     * @param page
     * @param mdmNoticeReqVo
     * @return
     */
    List<MdmNoticeRespVo> findList(Page<MdmNoticeRespVo> page, @Param("vo") MdmNoticeReqVo mdmNoticeReqVo);

    /**
     * 删除
     * @param mdmNoticeReqVo
     */
    void deleteProductsByParams(@Param("vo") MdmNoticeReqVo mdmNoticeReqVo);

    /**
     * 小程序公告列表
     * @param page
     * @param mdmNoticeReqVo
     * @param noticeReleaseStatus
     * @return
     */
    List<MdmNoticeRespVo> findListMiniPrg(Page<MdmNoticeRespVo> page, @Param("vo") MdmNoticeMiniReqVo mdmNoticeReqVo,@Param("noticeReleaseStatus") String noticeReleaseStatus);

    /**
     * 小程序公告最新
     * @param orgCodes
     * @return
     */
    List<MdmNoticeRespVo> findListMiniPrgNew(@Param("orgCodes") List<String> orgCodes);

    /**
     * 小程序详情
     * @param id
     * @return
     */
    MdmNoticeRespVo queryMimiPrg(@Param("id") String id);

    /**
     * 查询上一页/下一页
     * @param id
     * @param upStatus
     * @param orgCode
     * @return
     */
    String queryMinPrgUpOrBelow(@Param("id") String id, @Param("upStatus") String upStatus, @Param("orgCode") String orgCode);
}
