package com.biz.crm.notice.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeReadReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeReadRespVo;
import com.biz.crm.notice.model.MdmNoticeReadEntity;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 公告读取信息 
 * 
 * @author liuhongming
 * @date 2020-09-17 19:12:50
 */
public interface MdmNoticeReadMapper extends BaseMapper<MdmNoticeReadEntity> {
    /**
     * 列表
     * @param page
     * @param mdmNoticeReadReqVo
     * @return
     */
    List<MdmNoticeReadRespVo> findList(Page<MdmNoticeReadRespVo> page, @Param("vo") MdmNoticeReadReqVo mdmNoticeReadReqVo);

    /**
     * 根据notice_code 当前职位和账号 查询公告是否已读
     * @param notices
     * @return
     */
    List<MdmNoticeReadRespVo> findIsItRight(@Param("notices") List<String> notices, @Param("userName") String userName, @Param("thisPost") String thisPost, @Param("thisOrg") String thisOrg);

    /**
     * 查是否存在
     * @param req
     * @return
     */
    Integer findReadSignCount(@Param("vo") MdmNoticeReadReqVo req);

}
