package com.biz.crm.notice.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeCommentReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeCommentRespVo;

import java.util.List;

/**
 * 公告评论 接口
 *
 * @author yangshan
 * @date 2021-2-4 11:48:01
 */
public interface IMdmNoticeCommentService {
    /**
     * 根据公告id查询评论集合
     *
     * @param mdmNoticeCommentReqVo
     * @return
     */
    PageResult<MdmNoticeCommentRespVo> findCommentList(MdmNoticeCommentReqVo mdmNoticeCommentReqVo);

    /**
     * 新增评论
     * @param id id
     * @param commentText 评论内容
     */
    void save(String id,String commentText);

    /**
     * 更改评论状态
     * @param id
     */
    void updateNoticeVisible(String id);
}
