package com.biz.crm.notice.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeFileReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeFileRespVo;
import com.biz.crm.notice.model.MdmNoticeFileEntity;

import java.util.List;

/**
 * 公告附件 接口
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:43
 */
public interface IMdmNoticeFileService extends IService<MdmNoticeFileEntity> {

    /**
     * 列表
     * @param mdmNoticeFileReqVo
     * @return PageResult<MdmNoticeFileRespVo>
     */
    PageResult<MdmNoticeFileRespVo> findList(MdmNoticeFileReqVo mdmNoticeFileReqVo);

    /**
     * 查询
     * @param mdmNoticeFileReqVo
     * @return MdmNoticeFileRespVo
     */
    MdmNoticeFileRespVo query(MdmNoticeFileReqVo mdmNoticeFileReqVo);

    /**
     * 新增
     * @param mdmNoticeFileReqVo
     * @return
     */
    void save(MdmNoticeFileReqVo mdmNoticeFileReqVo);

    /**
     * 更新
     * @param mdmNoticeFileReqVo
     * @return
     */
    void update(MdmNoticeFileReqVo mdmNoticeFileReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);
}

