package com.biz.crm.notice.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeReadReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeReadRespVo;
import com.biz.crm.notice.model.MdmNoticeReadEntity;

import java.util.List;

/**
 * 公告读取信息 接口
 *
 * @author liuhongming
 * @date 2020-09-17 19:12:50
 */
public interface IMdmNoticeReadService extends IService<MdmNoticeReadEntity> {

    /**
     * 列表
     * @param mdmNoticeReadReqVo
     * @return PageResult<MdmNoticeReadRespVo>
     */
    PageResult<MdmNoticeReadRespVo> findList(MdmNoticeReadReqVo mdmNoticeReadReqVo);

    /**
     * 查询
     * @param mdmNoticeReadReqVo
     * @return MdmNoticeReadRespVo
     */
    MdmNoticeReadRespVo query(MdmNoticeReadReqVo mdmNoticeReadReqVo);

    /**
     * 新增
     * @param noticeCode
     * @return
     */
    void save(String noticeCode);

    /**
     * 更新
     * @param mdmNoticeReadReqVo
     * @return
     */
    void update(MdmNoticeReadReqVo mdmNoticeReadReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);
}

