package com.biz.crm.notice.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeMiniReqVo;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeRespVo;
import com.biz.crm.notice.model.MdmNoticeEntity;

import java.util.List;

/**
 * 公告管理 接口
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:42
 */
public interface IMdmNoticeService extends IService<MdmNoticeEntity> {

    /**
     * 列表
     * @param mdmNoticeReqVo
     * @return PageResult<MdmNoticeRespVo>
     */
    PageResult<MdmNoticeRespVo> findList(MdmNoticeReqVo mdmNoticeReqVo);

    /**
     * 首页公告列表
     * @param mdmNoticeReqVo
     * @return PageResult<MdmNoticeRespVo>
     */
    PageResult<MdmNoticeRespVo> homePageList(MdmNoticeReqVo mdmNoticeReqVo);


    /**
     * 小程序公告列表
     * @param reqVo
     * @return
     */
    PageResult<MdmNoticeRespVo> findListByMiniPrg(MdmNoticeMiniReqVo reqVo);
    /**
     * 小程序最新
     * @return
     */

    MdmNoticeRespVo queryMiniPrgNew();

    /**
     * 小程序公告详情
     * @param id
     * @return
     */
    MdmNoticeRespVo queryMiniPrg(String id);

    /**
     * 小程序公告详情(上一页/下一页)
     * @param id
     * @param upBelow
     * @return
     */
    MdmNoticeRespVo queryMiniPrgByUpBelow(String id,String upBelow);


    /**
     * 查询
     * @param mdmNoticeReqVo
     * @return MdmNoticeRespVo
     */
    MdmNoticeRespVo query(MdmNoticeReqVo mdmNoticeReqVo);

    /**
     * 新增
     * @param mdmNoticeReqVo
     * @return
     */
    void save(MdmNoticeReqVo mdmNoticeReqVo);

    /**
     * 更新
     * @param mdmNoticeReqVo
     * @return
     */
    void update(MdmNoticeReqVo mdmNoticeReqVo);

    /**
     * 删除
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);

    /**
     * 置顶
     * @param id
     */
    void top(String id);

    /**
     * 取消置顶
     * @param id
     */
    void cancelTop(String id);

    /**
     * 取消发布
     * @param id
     */
    void cancelRelease(String id);

    /**
     * 根据id发布
     * @param id
     */
    void releaseNoticeById(String id);

    /**
     * 小程序删除
     * @param id
     */
    void deleteById(String id);

    /**
     * 登录角色
     * @return
     */
    Boolean isNoticeAdmin();
}

