package com.biz.crm.notice.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeCommentReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeCommentRespVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeRespVo;
import com.biz.crm.notice.mapper.MdmNoticeCommentMapper;
import com.biz.crm.notice.mapper.MdmNoticeMapper;
import com.biz.crm.notice.model.MdmNoticeCommentEntity;
import com.biz.crm.notice.model.MdmNoticeEntity;
import com.biz.crm.notice.service.IMdmNoticeCommentService;
import com.biz.crm.notice.service.IMdmNoticeService;
import com.biz.crm.util.*;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author yangshan
 * @date 2021-2-4 11:48:11
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="MdmNoticeCommentServiceImpl")
@Transactional
public class MdmNoticeCommentServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmNoticeCommentMapper,MdmNoticeCommentEntity> implements IMdmNoticeCommentService {
    @Resource
    private MdmNoticeCommentMapper mdmNoticeCommentMapper;
    @Resource
    private MdmNoticeMapper mdmNoticeMapper;
    @Resource
    private IMdmNoticeService mdmNoticeService;


    /**
     * 评论列表
     * @param mdmNoticeCommentReqVo
     * @return
     */
    @Override
    public PageResult<MdmNoticeCommentRespVo> findCommentList(MdmNoticeCommentReqVo mdmNoticeCommentReqVo) {
        AssertUtils.isNotEmpty(mdmNoticeCommentReqVo.getNoticeId(), "公告id为空");
        Page<MdmNoticeCommentRespVo> page = new Page<>(mdmNoticeCommentReqVo.getPageNum(), mdmNoticeCommentReqVo.getPageSize());
        Boolean noticeAdmin = mdmNoticeService.isNoticeAdmin();
        if (!mdmNoticeService.isNoticeAdmin()){
            mdmNoticeCommentReqVo.setVisibleState(YesNoEnum.yesNoEnum.ONE.getValue());
        }
        List<MdmNoticeCommentRespVo> commentList = mdmNoticeCommentMapper.findCommentList(page, mdmNoticeCommentReqVo);
        if(!CollectionUtils.isEmpty(commentList)){
            commentList = commentList.stream().peek(x -> {
                String commentLikesState = x.getCommentLikesState();
                if (String.valueOf(YesNoEnum.YesNoCodeNumberEnum.NO.getCode()).equals(commentLikesState)) {
                    x.setCommentLikesState(YesNoEnum.YesNoCodeNumberEnum.NO.getValue());
                }
                x.setCommentLikesState(YesNoEnum.YesNoCodeNumberEnum.YES.getValue());
            }).collect(Collectors.toList());
        }
        return PageResult.<MdmNoticeCommentRespVo>builder()
                .data(commentList)
                .count(page.getTotal())
                .build();
    }

    /**
     * 新增评论
     * @param id id
     * @param commentText 评论内容
     */
    @Override
    public void save(String id, String commentText) {
        AssertUtils.isNotEmpty(id,"公告id不能为空");
        //公告存在校验
        MdmNoticeEntity mdmNotice = mdmNoticeMapper.selectById(id);
        AssertUtils.isNotNull(mdmNotice, "该公告可能已经被删除了");
        UserRedis user = UserUtils.getUser();
        MdmNoticeCommentReqVo mdmNoticeCommentReqVo = new MdmNoticeCommentReqVo();
        String commentTime = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now());
        mdmNoticeCommentReqVo.setNoticeId(id)
                .setCommentName(user.getUsername())
                .setCommentOrgName(user.getOrgname())
                .setCommentPosName(user.getPosname())
                .setCommentText(commentText)
                .setCommentTime(commentTime)
                .setCommentNumLikes(YesNoEnum.YesNoCodeNumberEnum.NO.getCode().toString())
                .setVisibleState(YesNoEnum.YesNoCodeNumberEnum.YES.getCode().toString());
        MdmNoticeCommentEntity noticeCommentEntity = CrmBeanUtil.copy(mdmNoticeCommentReqVo, MdmNoticeCommentEntity.class);
        this.save(noticeCommentEntity);
    }

    /**
     * 更改评论状态
     * @param id
     */
    @Override
    public void updateNoticeVisible(String id) {
        AssertUtils.isNotEmpty(id,"评论id不能为空");
        //评论存在校验
        MdmNoticeCommentEntity mdmNoticeCommentEntity = mdmNoticeCommentMapper.selectById(id);
        Assert.notNull(mdmNoticeCommentEntity, "该评论可能已经被删除了");
        String visibleState = mdmNoticeCommentEntity.getVisibleState();
        if (YesNoEnum.YesNoCodeNumberEnum.NO.getCode().toString().equals(visibleState)){
            mdmNoticeCommentEntity.setVisibleState(YesNoEnum.YesNoCodeNumberEnum.YES.getCode().toString());
        }else {
            mdmNoticeCommentEntity.setVisibleState(YesNoEnum.YesNoCodeNumberEnum.NO.getCode().toString());
        }
        mdmNoticeCommentMapper.updateById(mdmNoticeCommentEntity);
    }

}
