package com.biz.crm.notice.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeFileReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeFileRespVo;
import com.biz.crm.notice.mapper.MdmNoticeFileMapper;
import com.biz.crm.notice.model.MdmNoticeFileEntity;
import com.biz.crm.notice.service.IMdmNoticeFileService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 公告附件 接口实现
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:43
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="MdmNoticeFileServiceExpandImpl")
@Transactional
public class MdmNoticeFileServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmNoticeFileMapper, MdmNoticeFileEntity> implements IMdmNoticeFileService {

    @Resource
    private MdmNoticeFileMapper mdmNoticeFileMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    @CrmLog
    public PageResult<MdmNoticeFileRespVo> findList(MdmNoticeFileReqVo reqVo){
        Page<MdmNoticeFileRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<MdmNoticeFileRespVo> list = mdmNoticeFileMapper.findList(page, reqVo);
        list.forEach(data->{
            data.setFilePath(data.getRealPath()+data.getUrlPath());
        });
        return PageResult.<MdmNoticeFileRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return MdmNoticeFileRespVo
     */
    @Override
    @CrmLog
    public MdmNoticeFileRespVo query(MdmNoticeFileReqVo reqVo){
        List<MdmNoticeFileRespVo> list = this.findList(reqVo).getData();
        if(CollectionUtils.isEmpty(list)){
            return new MdmNoticeFileRespVo();
        }
        MdmNoticeFileRespVo mdmNoticeFileRespVo = list.get(0);
        return mdmNoticeFileRespVo;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @CrmLog
    public void save(MdmNoticeFileReqVo reqVo){
        MdmNoticeFileEntity entity = CrmBeanUtil.copy(reqVo, MdmNoticeFileEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @CrmLog
    public void update(MdmNoticeFileReqVo reqVo){
        MdmNoticeFileEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param ids
     * @return
     */
    @Override
    @CrmLog
    public void deleteBatch(List<String> ids){
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)){
            throw new BusinessException("数据主键不能为空");
        }
        List<MdmNoticeFileEntity> mdmNoticeFileEntities = mdmNoticeFileMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(mdmNoticeFileEntities)){
            mdmNoticeFileEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(mdmNoticeFileEntities);
    }

    /**
     * 启用
     * @param ids
     * @return
     */
    @Override
    @CrmLog
    public void enableBatch(List<String> ids){
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)){
            throw new BusinessException("数据主键不能为空");
        }
        //设置状态为启用
        List<MdmNoticeFileEntity> mdmNoticeFileEntities = mdmNoticeFileMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(mdmNoticeFileEntities)){
            mdmNoticeFileEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(mdmNoticeFileEntities);
    }

    /**
     * 禁用
     * @param ids
     * @return
     */
    @Override
    @CrmLog
    public void disableBatch(List<String> ids){
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)){
            throw new BusinessException("数据主键不能为空");
        }
        //设置状态为禁用
        List<MdmNoticeFileEntity> mdmNoticeFileEntities = mdmNoticeFileMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(mdmNoticeFileEntities)){
                mdmNoticeFileEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(mdmNoticeFileEntities);
    }
}
