package com.biz.crm.notice.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeReceivingReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeReceivingRespVo;
import com.biz.crm.notice.mapper.MdmNoticeReceivingMapper;
import com.biz.crm.notice.model.MdmNoticeReceivingEntity;
import com.biz.crm.notice.service.IMdmNoticeReceivingService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;

/**
 * 公告发布范围 接口实现
 *
 * @author liuhongming
 * @date 2020-09-17 17:14:43
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name="MdmNoticeReceivingServiceExpandImpl")
@Transactional
public class MdmNoticeReceivingServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmNoticeReceivingMapper, MdmNoticeReceivingEntity> implements IMdmNoticeReceivingService {

    @Resource
    private MdmNoticeReceivingMapper mdmNoticeReceivingMapper;

    /**
     * 列表
     * @param reqVo
     * @return
     */
    @Override
    @CrmLog
    public PageResult<MdmNoticeReceivingRespVo> findList(MdmNoticeReceivingReqVo reqVo){
        Page<MdmNoticeReceivingRespVo> page = new Page<>(reqVo.getPageNum(), reqVo.getPageSize());
        List<MdmNoticeReceivingRespVo> list = mdmNoticeReceivingMapper.findList(page, reqVo);
        return PageResult.<MdmNoticeReceivingRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    /**
     * 查询
     * @param reqVo
     * @return MdmNoticeReceivingRespVo
     */
    @Override
    @CrmLog
    public MdmNoticeReceivingRespVo query(MdmNoticeReceivingReqVo reqVo){
        return null;
    }

    /**
     * 新增
     * @param reqVo
     * @return
     */
    @Override
    @CrmLog
    public void save(MdmNoticeReceivingReqVo reqVo){
        MdmNoticeReceivingEntity entity = CrmBeanUtil.copy(reqVo, MdmNoticeReceivingEntity.class);
        this.save(entity);
    }

    /**
     * 更新
     * @param reqVo
     * @return
     */
    @Override
    @CrmLog
    public void update(MdmNoticeReceivingReqVo reqVo){
        MdmNoticeReceivingEntity entity = this.getById(reqVo.getId());
        this.updateById(entity);
    }

    /**
     * 删除
     * @param ids
     * @return
     */
    @Override
    @CrmLog
    public void deleteBatch(List<String> ids){
        if (CollectionUtil.listNotEmptyNotSizeZero(ids)){
            throw new BusinessException("数据主键不能为空");
        }
        List<MdmNoticeReceivingEntity> mdmNoticeReceivingEntities = mdmNoticeReceivingMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(mdmNoticeReceivingEntities)){
            mdmNoticeReceivingEntities.forEach(o -> {
                 o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
            });
        }
        this.updateBatchById(mdmNoticeReceivingEntities);
    }

    /**
     * 启用
     * @param ids
     * @return
     */
    @Override
    @CrmLog
    public void enableBatch(List<String> ids){
        if (CollectionUtil.listNotEmptyNotSizeZero(ids)){
            throw new BusinessException("数据主键不能为空");
        }
        //设置状态为启用
        List<MdmNoticeReceivingEntity> mdmNoticeReceivingEntities = mdmNoticeReceivingMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(mdmNoticeReceivingEntities)){
            mdmNoticeReceivingEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            });
        }
        this.updateBatchById(mdmNoticeReceivingEntities);
    }

    /**
     * 禁用
     * @param ids
     * @return
     */
    @Override
    @CrmLog
    public void disableBatch(List<String> ids){
        if (CollectionUtil.listNotEmptyNotSizeZero(ids)){
            throw new BusinessException("数据主键不能为空");
        }
        //设置状态为禁用
        List<MdmNoticeReceivingEntity> mdmNoticeReceivingEntities = mdmNoticeReceivingMapper.selectBatchIds(ids);
        if(CollectionUtils.isNotEmpty(mdmNoticeReceivingEntities)){
                mdmNoticeReceivingEntities.forEach(o -> {
                o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            });
        }
        this.updateBatchById(mdmNoticeReceivingEntities);
    }
}
