package com.biz.crm.org.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRedisVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgReloadRedisVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.util.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 组织表redis缓存数据查询请求接口类
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Slf4j
@RestController
@RequestMapping("/mdmOrgRedisController")
@CrmGlobalLog
public class MdmOrgRedisController {

    @Autowired
    private MdmOrgService mdmOrgService;

    /**
     * 根据组织编码集合获取组织详情redis缓存数据
     *
     * @param orgCodeList 组织编码集合
     * @return
     */
    @PostMapping("/findRedisListByOrgCodeList")
    public Result<List<MdmOrgRedisVo>> findRedisListByOrgCodeList(@RequestBody List<String> orgCodeList) {
        return Result.ok(mdmOrgService.findRedisListByOrgCodeList(orgCodeList));
    }

    /**
     * 根据组织编码集合获取组织上级redis缓存数据
     *
     * @param orgCodeList 组织编码集合
     * @return
     */
    @PostMapping("/findRedisOrgParentListByCodeList")
    public Result<List<MdmOrgParentChildrenRedisVo>> findRedisOrgParentListByCodeList(@RequestBody List<String> orgCodeList) {
        return Result.ok(mdmOrgService.findRedisOrgParentListByCodeList(orgCodeList));
    }

    /**
     * 根据组织编码集合获取组织下级redis缓存数据
     *
     * @param orgCodeList 组织编码集合
     * @return
     */
    @PostMapping("/findRedisOrgChildrenListByCodeList")
    public Result<List<MdmOrgParentChildrenRedisVo>> findRedisOrgChildrenListByCodeList(@RequestBody List<String> orgCodeList) {
        return Result.ok(mdmOrgService.findRedisOrgChildrenListByCodeList(orgCodeList));
    }

    /**
     * 获取全部组织redis缓存数据
     *
     * @return
     */
    @PostMapping("/findRedisReloadList")
    public Result<List<MdmOrgReloadRedisVo>> findRedisReloadList() {
        return Result.ok(mdmOrgService.findRedisReloadList());
    }

}
