package com.biz.crm.org.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.org.req.MdmOrgRelCustomerPageReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgRelCustomerReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRelCustomerPageRespVo;
import com.biz.crm.org.service.MdmOrgCustomerService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 组织表
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Slf4j
@RestController
@RequestMapping("/mdmOrgRelationCustomerController")
@Api(tags = "MDM-组织管理-组织关联客户")
@CrmGlobalLog
public class MdmOrgRelationCustomerController {

    @Autowired
    private MdmOrgCustomerService mdmOrgCustomerService;

    @ApiOperation(value = "分页查询组织关联客户列表")
    @PostMapping("/findOrgCustomerList")
    @CrmDictMethod
    public Result<PageResult<MdmOrgRelCustomerPageRespVo>> findOrgCustomerList(@RequestBody MdmOrgRelCustomerPageReqVo reqVo) {
        return Result.ok(mdmOrgCustomerService.findOrgCustomerList(reqVo));
    }

    @ApiOperation(value = "批量替换客户关联的组织")
    @PostMapping("/batchUpdateCustomerOrg")
    public Result batchUpdateCustomerOrg(@RequestBody MdmOrgRelCustomerReqVo reqVo) {
        mdmOrgCustomerService.batchUpdateCustomerOrg(reqVo);
        return Result.ok();
    }


}
