package com.biz.crm.org.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.org.req.MdmOrgRelTerminalPageReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgRelTerminalReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRelTerminalPageRespVo;
import com.biz.crm.org.service.MdmOrgTerminalService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 组织表
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Slf4j
@RestController
@RequestMapping("/mdmOrgRelationTerminalController")
@Api(tags = "MDM-组织管理-组织关联终端")
@CrmGlobalLog
public class MdmOrgRelationTerminalController {

    @Autowired
    private MdmOrgTerminalService mdmOrgTerminalService;

    @ApiOperation(value = "分页查询组织关联终端列表")
    @PostMapping("/findOrgTerminalList")
    @CrmDictMethod
    public Result<PageResult<MdmOrgRelTerminalPageRespVo>> findOrgTerminalList(@RequestBody MdmOrgRelTerminalPageReqVo reqVo) {
        return Result.ok(mdmOrgTerminalService.findOrgTerminalList(reqVo));
    }

    @ApiOperation(value = "批量修改终端关联的组织")
    @PostMapping("/batchUpdateTerminalOrg")
    public Result batchUpdateTerminalOrg(@RequestBody MdmOrgRelTerminalReqVo reqVo) {
        mdmOrgTerminalService.batchUpdateTerminalOrg(reqVo);
        return Result.ok();
    }


}
