package com.biz.crm.org.provider;

import com.biz.crm.eunm.mdm.MdmProviderEnum;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.ProviderUtil;
import org.apache.ibatis.jdbc.SQL;

import java.util.List;
import java.util.Map;

/**
 * @Author hej
 * @Created Date 2021-01-08 11:42
 **/
public class MdmOrgProvider {

    public String findListProvider(Map<String,Object> map){
        MdmOrgReqVo vo = (MdmOrgReqVo) map.get("vo");
        List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL(){{
            SELECT("a.*,a2.org_name as parent_name");
            FROM("mdm_org a");
            LEFT_OUTER_JOIN("mdm_org a2 on a.parent_code = a2.org_code");
            if(StringUtils.isNotEmpty(vo.getOrgType())){
                WHERE(" a.org_type=#{vo.orgType}");
            }
            if(StringUtils.isNotEmpty(vo.getParentCode())){
                WHERE("a.parent_code=#{vo.parentCode}");
            }
            if(StringUtils.isNotEmpty(vo.getEnableStatus())){
                WHERE("a.enable_status=#{vo.enableStatus}");
            }
            if(StringUtils.isNotEmpty(vo.getOrgCode())){
                WHERE("a.org_code like "+ ProviderUtil.bindPercent(vo.getOrgCode(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getOrgName())){
                WHERE("a.org_name like "+ ProviderUtil.bindPercent(vo.getOrgName(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getRuleCode())){
                WHERE("a.rule_code like "+ ProviderUtil.bindPercent(vo.getRuleCode(), MdmProviderEnum.SQL_JOIN_RIGHT));
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(cvo)) {
                WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
            }
            ORDER_BY("a.enable_status desc, a.update_date desc, a.update_date_second desc");
        }}.toString();
    }

}
