package com.biz.crm.org.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.mdm.org.req.MdmOrgRegionReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRegionRespVo;
import com.biz.crm.org.model.MdmOrgRegionEntity;

import java.util.List;

/**
 * 组织和行政区域关联表接口
 *
 * @author Tao.Chen
 * @date 2020-11-17 10:42:46
 */
public interface MdmOrgRegionService extends IService<MdmOrgRegionEntity> {

    /**
     * 查询组织和行政区域关联关系
     *
     * @param reqVo
     * @return
     */
    List<MdmOrgRegionRespVo> findOrgRegionList(MdmOrgRegionReqVo reqVo);

    /**
     * 保存组织和行政区域关联关系
     *
     * @param reqVo
     */
    void saveOrgRegion(MdmOrgRegionReqVo reqVo);

    /**
     * 根据组织编码集合查询组织关联的行政区域
     *
     * @param orgCodeList
     * @return
     */
    List<MdmOrgRegionRespVo> findOrgRegionByOrgCodeList(List<String> orgCodeList);
}

