package com.biz.crm.org.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgCustomerUpdateReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgRelCustomerPageReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgRelCustomerReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRelCustomerPageRespVo;
import com.biz.crm.org.mapper.MdmOrgCustomerMapper;
import com.biz.crm.org.service.MdmOrgCustomerService;
import com.biz.crm.util.PageUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.List;

@Service
public class MdmOrgCustomerServiceImpl implements MdmOrgCustomerService {

    @Resource
    private MdmOrgCustomerMapper mdmOrgCustomerMapper;
    @Resource
    private MdmCustomerMsgService mdmcustomerMsgService;

    @Override
    public PageResult<MdmOrgRelCustomerPageRespVo> findOrgCustomerList(MdmOrgRelCustomerPageReqVo reqVo) {
        Assert.hasText(reqVo.getOrgCode(), "缺失组织编码");
        Page<MdmOrgRelCustomerPageRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmOrgRelCustomerPageRespVo> list = mdmOrgCustomerMapper.findOrgCustomerList(page, reqVo);
        return PageResult.<MdmOrgRelCustomerPageRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchUpdateCustomerOrg(MdmOrgRelCustomerReqVo reqVo) {
        Assert.hasText(reqVo.getOrgCode(), "缺失组织编码");
        Assert.hasText(reqVo.getOriginOrgCode(), "缺失源组织编码");
        Assert.notEmpty(reqVo.getCustomerCodeList(), "缺失客户编码");
        MdmOrgCustomerUpdateReqVo mdmOrgCustomerReqVo = new MdmOrgCustomerUpdateReqVo();
        mdmOrgCustomerReqVo.setCustomerCodeList(reqVo.getCustomerCodeList());
        mdmOrgCustomerReqVo.setOriginOrgCode(reqVo.getOriginOrgCode());
        mdmOrgCustomerReqVo.setOrgCode(reqVo.getOrgCode());
        mdmcustomerMsgService.batchUpdateCustomerOrg(mdmOrgCustomerReqVo);
    }
}
