package com.biz.crm.org.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.mdm.MdmBpmStatusEnum;
import com.biz.crm.nebular.mdm.org.req.MdmOrgRelTerminalPageReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgRelTerminalReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRelTerminalPageRespVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmOrgTerminalReqVo;
import com.biz.crm.org.mapper.MdmOrgTerminalMapper;
import com.biz.crm.org.service.MdmOrgTerminalService;
import com.biz.crm.terminal.service.MdmTerminalService;
import com.biz.crm.util.PageUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.List;

@Service
public class MdmOrgTerminalServiceImpl implements MdmOrgTerminalService {

    @Resource
    private MdmTerminalService mdmTerminalService;
    @Resource
    private MdmOrgTerminalMapper mdmOrgTerminalMapper;

    @Override
    public PageResult<MdmOrgRelTerminalPageRespVo> findOrgTerminalList(MdmOrgRelTerminalPageReqVo reqVo) {
        Assert.hasText(reqVo.getOrgCode(), "缺失组织编码");
        Page<MdmOrgRelTerminalPageRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        reqVo.setActApproveStatus(MdmBpmStatusEnum.PASS.getValue());
        List<MdmOrgRelTerminalPageRespVo> list = mdmOrgTerminalMapper.findOrgTerminalList(page, reqVo);
        return PageResult.<MdmOrgRelTerminalPageRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchUpdateTerminalOrg(MdmOrgRelTerminalReqVo reqVo) {
        Assert.hasText(reqVo.getOrgCode(), "缺失组织编码");
        Assert.hasText(reqVo.getOriginOrgCode(), "缺失源组织编码");
        Assert.notEmpty(reqVo.getTerminalCodeList(), "缺失终端编码");
        MdmOrgTerminalReqVo mdmOrgTerminalReqVo = new MdmOrgTerminalReqVo();
        mdmOrgTerminalReqVo.setOrgCode(reqVo.getOrgCode());
        mdmOrgTerminalReqVo.setOriginOrgCode(reqVo.getOriginOrgCode());
        mdmOrgTerminalReqVo.setTerminalCodeList(reqVo.getTerminalCodeList());
        mdmTerminalService.batchUpdateTerminalOrg(mdmOrgTerminalReqVo);
    }
}
