package com.biz.crm.parametermanage.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.parametermanage.req.MdmParameterManageReqVo;
import com.biz.crm.nebular.mdm.parametermanage.resp.MdmParameterManageRespVo;
import com.biz.crm.parametermanage.service.MdmParameterManageService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 参数配置
 *
 * @author Tao.Chen
 * @date 2020-11-24 10:47:10
 */
@Slf4j
@RestController
@RequestMapping("/mdmparametermanage")
@Api(tags = "全局参数配置")
@CrmGlobalLog
public class MdmParameterManageController {

    @Autowired
    private MdmParameterManageService mdmParameterManageService;

    @ApiOperation(value = "查询分页列表")
    @PostMapping("/list")
    @CrmDictMethod
    public Result<PageResult<MdmParameterManageRespVo>> list(@RequestBody MdmParameterManageReqVo mdmParameterManageReqVo) {
        PageResult<MdmParameterManageRespVo> result = mdmParameterManageService.findList(mdmParameterManageReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value = "查询（传id或parameterCode）")
    @PostMapping("/query")
    @CrmDictMethod
    public Result<MdmParameterManageRespVo> query(@RequestBody MdmParameterManageReqVo mdmParameterManageReqVo) {
        MdmParameterManageRespVo respVo = mdmParameterManageService.query(mdmParameterManageReqVo);
        return Result.ok(respVo);
    }

    @ApiOperation(value = "新增")
    @PostMapping("/save")
    public Result save(@RequestBody MdmParameterManageReqVo mdmParameterManageReqVo) {
        mdmParameterManageService.save(mdmParameterManageReqVo);
        return Result.ok();
    }

    @ApiOperation(value = "更新")
    @PostMapping("/update")
    public Result update(@RequestBody MdmParameterManageReqVo mdmParameterManageReqVo) {
        mdmParameterManageService.update(mdmParameterManageReqVo);
        return Result.ok("修改成功");
    }

    @ApiOperation(value = "删除", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/delete")
    public Result delete(@RequestBody List<String> ids) {
        mdmParameterManageService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    @ApiOperation(value = "清除全部缓存", httpMethod = "POST")
    @PostMapping("/deleteAllCache")
    public Result deleteAllCache() {
        mdmParameterManageService.deleteAllCache();
        return Result.ok("删除成功");
    }

    @ApiOperation(value = "根据id集合批量清除缓存", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/deleteCacheByIds")
    public Result deleteCacheByIds(@RequestBody List<String> ids) {
        mdmParameterManageService.deleteCacheByIds(ids);
        return Result.ok("删除成功");
    }

    @ApiOperation(value = "根据编码集合批量清除缓存", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "codeList", value = "编码集合", required = true, paramType = "body")
    })
    @PostMapping("/deleteCacheByCodeList")
    public Result deleteCacheByCodeList(@RequestBody List<String> codeList) {
        mdmParameterManageService.deleteCacheByCodeList(codeList);
        return Result.ok("删除成功");
    }

}
