package com.biz.crm.parametermanage.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.parametermanage.req.MdmParameterManageReqVo;
import com.biz.crm.nebular.mdm.parametermanage.resp.MdmParameterManageRespVo;
import com.biz.crm.parameter.vo.ParameterVo;
import com.biz.crm.parametermanage.model.MdmParameterManageEntity;

import java.util.List;

/**
 * 参数配置接口
 *
 * @author Tao.Chen
 * @date 2020-11-24 10:47:10
 */
public interface MdmParameterManageService extends IService<MdmParameterManageEntity> {

    /**
     * 列表
     *
     * @param mdmParameterManageReqVo
     * @return PageResult<MdmParameterManageRespVo>
     */
    PageResult<MdmParameterManageRespVo> findList(MdmParameterManageReqVo mdmParameterManageReqVo);

    /**
     * 查询
     *
     * @param mdmParameterManageReqVo
     * @return MdmParameterManageRespVo
     */
    MdmParameterManageRespVo query(MdmParameterManageReqVo mdmParameterManageReqVo);

    /**
     * 新增
     *
     * @param mdmParameterManageReqVo
     * @return
     */
    void save(MdmParameterManageReqVo mdmParameterManageReqVo);

    /**
     * 更新
     *
     * @param mdmParameterManageReqVo
     * @return
     */
    void update(MdmParameterManageReqVo mdmParameterManageReqVo);

    /**
     * 删除
     *
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 清除全部全局参数缓存
     */
    void deleteAllCache();

    /**
     * 根据id批量清除缓存
     *
     * @param ids id集合
     */
    void deleteCacheByIds(List<String> ids);

    /**
     * 根据编码批量删除缓存
     *
     * @param codeList 编码集合
     */
    void deleteCacheByCodeList(List<String> codeList);

    /**
     * 批量获取全局参数用于redis缓存
     *
     * @param parameterCodeList
     * @return
     */
    List<ParameterVo> getParameterRedisList(List<String> parameterCodeList);

}

