package com.biz.crm.permission.controller;


import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.function.MdmFunctionReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import com.biz.crm.nebular.mdm.permission.*;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionPageRespVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.permission.service.IMdmDataPermissionExtendService;
import com.biz.crm.permission.service.IMdmDataPermissionService;
import com.biz.crm.util.PermissionUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * 数据权限
 *
 * @author zxw
 * @date 2020-10-26 12:09:31
 */
@Slf4j
@RestController
@RequestMapping("/mdmDataPermissionController")
@Api(tags = "数据权限")
@CrmGlobalLog
public class MdmDataPermissionController {

    @Resource
    private IMdmDataPermissionService mdmDataPermissionService;

    @Autowired
    private IMdmDataPermissionExtendService mdmDataPermissionExtendService;

    @ApiOperation(value = "分页查询")
    @PostMapping("/page")
    @CrmDictMethod
    public Result<PageResult<MdmDataPermissionRespVo>> page(@RequestBody MdmDataPermissionReqVo mdmDataPermissionReqVo) {
        PageResult<MdmDataPermissionRespVo> result = mdmDataPermissionService.findList(mdmDataPermissionReqVo);
        return Result.ok(result);
    }

    @ApiOperation("根据角色，菜单，列表查询对象与方式")
    @PostMapping("/queryCondition")
    @CrmDictMethod
    public Result<MdmDataPermissionRespVo> queryCondition(@RequestBody MdmDataPermissionReqVo mdmDataPermissionReqVo) {
        return Result.ok(mdmDataPermissionService.queryCondition(mdmDataPermissionReqVo));
    }

    @ApiOperation(value = "查询")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "query"),
    })
    @PostMapping("/query")
    @CrmDictMethod
    public Result<MdmDataPermissionRespVo> query(@RequestParam("id") String id) {
        MdmDataPermissionReqVo mdmDataPermissionReqVo = new MdmDataPermissionReqVo();
        mdmDataPermissionReqVo.setId(id);
        MdmDataPermissionRespVo respVo = mdmDataPermissionService.query(mdmDataPermissionReqVo);
        return Result.ok(respVo);
    }

    @ApiOperation("根据列表编码和菜单编码查询已配置的权限对象")
    @PostMapping("/objList")
    public Result<List<MdmPermissionObjRespVo>> objList(@RequestBody MdmDataPermissionReqVo mdmDataPermissionReqVo) {
        return Result.ok(mdmDataPermissionService.objList(mdmDataPermissionReqVo));
    }

    @ApiOperation(value = "新增")
    @PostMapping("/save")
    public Result<Object> save(@RequestBody MdmDataPermissionReqVo mdmDataPermissionReqVo) {
        mdmDataPermissionService.save(mdmDataPermissionReqVo);
        return Result.ok();
    }

    @ApiOperation(value = "更新")
    @PostMapping("/update")
    public Result<Object> update(@RequestBody MdmDataPermissionReqVo mdmDataPermissionReqVo) {
        mdmDataPermissionService.update(mdmDataPermissionReqVo);
        return Result.ok("修改成功");
    }

    @ApiOperation("更新当前及下级所有菜单数据权限")
    @PostMapping("/updateAllSub")
    public Result<Object> updateAllSub(@RequestBody MdmDataPermissionReqVo mdmDataPermissionReqVo) {
        mdmDataPermissionService.updateAllSub(mdmDataPermissionReqVo);
        return Result.ok("修改成功");
    }

    @ApiOperation(value = "删除")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/delete")
    public Result<Object> delete(@RequestBody List<String> ids) {
        MdmDataPermissionReqVo mdmDataPermissionReqVo = new MdmDataPermissionReqVo();
        mdmDataPermissionReqVo.setIds(ids);
        mdmDataPermissionService.deleteBatch(mdmDataPermissionReqVo);
        return Result.ok("删除成功");
    }

    @ApiOperation(value = "启用")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/enable")
    public Result<Object> enable(@RequestBody List<String> ids) {
        MdmDataPermissionReqVo mdmDataPermissionReqVo = new MdmDataPermissionReqVo();
        mdmDataPermissionReqVo.setIds(ids);
        mdmDataPermissionService.enableBatch(mdmDataPermissionReqVo);
        return Result.ok("启用成功");
    }

    @ApiOperation(value = "禁用")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/disable")
    public Result<Object> disable(@RequestBody List<String> ids) {
        MdmDataPermissionReqVo mdmDataPermissionReqVo = new MdmDataPermissionReqVo();
        mdmDataPermissionReqVo.setIds(ids);
        mdmDataPermissionService.disableBatch(mdmDataPermissionReqVo);
        return Result.ok("禁用成功");
    }

    @ApiOperation(value = "获取当前用户的数据权限")
    @PostMapping("/currentUserDataPermission")
    public Result<MdmCurrentPermissionRespVo> currentUserDataPermission(@RequestParam("competenceCode") String competenceCode, @RequestParam("listConfigCode") String listConfigCode) {
        MdmCurrentPermissionRespVo result = mdmDataPermissionService.currentUserDataPermission(competenceCode, listConfigCode);
        return Result.ok(result);
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "permissionObjCode", value = "权限对象编码", required = true, paramType = "query")
    })
    @ApiOperation("根据查询对象获取查询方式列表")
    @GetMapping("/searchTypeList")
    public Result<Map<String, String>> searchTypeList(@RequestParam("permissionObjCode") String permissionObjCode) {
        return Result.ok(mdmDataPermissionService.searchTypeList(permissionObjCode));
    }

    @ApiOperation("菜单下拉框")
    @PostMapping("/functionSelect")
    public Result<List<MdmFunctionRespVo>> functionSelect(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        List<MdmFunctionRespVo> mdmFunctionRespVo = mdmDataPermissionService.functionSelect(mdmFunctionReqVo);
        return Result.ok(mdmFunctionRespVo);
    }

    @ApiOperation("菜单树")
    @PostMapping("/functionTree")
    public Result<List<MdmFunctionRespVo>> functionTree(@RequestBody MdmFunctionReqVo mdmFunctionReqVo) {
        List<MdmFunctionRespVo> list = mdmDataPermissionService.functionTree(mdmFunctionReqVo);
        return Result.ok(list);
    }

    @ApiOperation("角色下拉框列表")
    @PostMapping("/roleSelectList")
    public Result<List<MdmRoleRespVo>> roleSelectList(@RequestBody MdmDataPermissionReqVo mdmDataPermissionReqVo) {
        List<MdmRoleRespVo> data = mdmDataPermissionService.roleSelectList(mdmDataPermissionReqVo);
        return Result.ok(data);
    }

    @ApiOperation("功能列表下拉框")
    @PostMapping("/configList")
    public Result<List<MdmListConfigRespVo>> configList(@RequestBody MdmDataPermissionReqVo mdmDataPermissionReqVo) {
        List<MdmListConfigRespVo> list = mdmDataPermissionService.configList(mdmDataPermissionReqVo);
        return Result.ok(list);
    }

    @ApiOperation("获取当前用户权限sql")
    @PostMapping("/currentUserPermissionSql")
    public Result<List<MdmPermissionSetVo>> currentUserPermissionSql() {
        return Result.ok(mdmDataPermissionService.currentUserPermissionSql());
    }

    @ApiOperation("权限sql工具类")
    @PostMapping("/permissionUtil")
    public Result<List<MdmPermissionSetVo>> permissionUtil() {
        return Result.ok(PermissionUtil.currentUserPermissionSql());
    }

    @ApiOperation("保存数据权限")
    @PostMapping("/add")
    public Result<Object> add(@RequestBody MdmDataPermissionVo mdmDataPermissionVo) {
        mdmDataPermissionService.save(mdmDataPermissionVo);
        return Result.ok();
    }

    @ApiOperation("查询权限详情")
    @PostMapping("/queryDetail")
    @CrmDictMethod
    public Result<MdmDataPermissionVo> queryDetail(@RequestBody MdmDataPermissionVo mdmDataPermissionVo) {
        return Result.ok(mdmDataPermissionService.queryDetail(mdmDataPermissionVo));
    }

    @ApiOperation("分页查询列表(新)")
    @PostMapping("/newPage")
    @CrmDictMethod
    public Result<PageResult<MdmDataPermissionExtendVo>> page(@RequestBody MdmDataPermissionExtendVo mdmDataPermissionExtendVo) {
        return Result.ok(mdmDataPermissionExtendService.findList(mdmDataPermissionExtendVo));
    }

    @ApiOperation(value = "已选职位分页列表查询")
    @PostMapping("/relationPositionPageList")
    @CrmDictMethod
    public Result<PageResult<MdmPositionPageRespVo>> relationPositionPageList(@RequestBody MdmDataPermissionVo mdmDataPermissionVo) {
        return Result.ok(mdmDataPermissionExtendService.relationPositionPageList(mdmDataPermissionVo));
    }

    @ApiOperation(value = "未选职位分页列表查询")
    @PostMapping("/unRelationPositionPageList")
    @CrmDictMethod
    public Result<PageResult<MdmPositionPageRespVo>> unRelationPositionPageList(@RequestBody MdmDataPermissionVo mdmDataPermissionVo) {
        return Result.ok(mdmDataPermissionExtendService.unRelationPositionPageList(mdmDataPermissionVo));
    }
}
