package com.biz.crm.permission.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.mdm.function.MdmFunctionReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionReqVo;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionRespVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.permission.model.MdmDataPermissionEntity;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 数据权限
 * 
 * @author zxw
 * @date 2020-10-26 12:09:31
 */
public interface MdmDataPermissionMapper extends BaseMapper<MdmDataPermissionEntity> {
    /**
     * 列表
     * @param page
     * @param mdmDataPermissionReqVo
     * @return
     */
    @SqlPrivilege(orgCode = "f.org_code")
    List<MdmDataPermissionRespVo> findList(Page<MdmDataPermissionRespVo> page, @Param("vo") MdmDataPermissionReqVo mdmDataPermissionReqVo);

    /**
     * 获取当前用户的数据权限
     * @param mdmDataPermissionReqVo 权限条件
     * @return list
     */
    List<MdmDataPermissionRespVo> currentUserDataPermission(@Param("vo") MdmDataPermissionReqVo mdmDataPermissionReqVo);

    /**
     * 权限查询
     * @param mdmDataPermissionReqVo vo
     * @return vo
     */
    @SqlPrivilege(
            posCode = "a.position_code",orgCode = "a.org_code"
    )
    MdmDataPermissionRespVo queryCondition(@Param("vo") MdmDataPermissionReqVo mdmDataPermissionReqVo);

    /**
     * 查询角色关联对应的已配置权限菜单列表
     * @param mdmFunctionReqVo
     * @return
     */
    List<String> functionCodeSelect(@Param("vo") MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 查询角色关联对应的已配置权限菜单列表
     * @param mdmFunctionReqVo
     * @return
     */
    List<MdmFunctionRespVo> functionSelect(@Param("vo") MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 菜单关联的角色下拉框
     * @param mdmDataPermissionReqVo vo
     * @return list
     */
    @SqlPrivilege(
            extPosSql = "select 1 from mdm_position_role where role_code=a.role_code and position_code in",
            extOrgSql = "select 1 from mdm_position p join mdm_org o on p.org_code=o.org_code join mdm_position_role pr on pr.position_code=p.position_code where a.role_code=pr.role_code and p.org_code in"
    )
    List<MdmRoleRespVo> roleFunctionSelectList(@Param("vo") MdmDataPermissionReqVo mdmDataPermissionReqVo);
}
