package com.biz.crm.permission.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionDetailVo;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionExtendVo;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionPageRespVo;
import com.biz.crm.permission.model.MdmDataPermissionExtendEntity;

import java.util.List;

/**
 * 接口
 *
 * @author zxw
 * @date 2021-01-07 10:28:30
 */
public interface IMdmDataPermissionExtendService extends IService<MdmDataPermissionExtendEntity> {

    /**
     * 添加
     *
     * @param entityList list
     */
    void add(List<MdmDataPermissionExtendEntity> entityList);

    /**
     * 条件查询
     *
     * @param mdmDataPermissionVo vo
     * @return list
     */
    List<MdmDataPermissionDetailVo> listCondition(MdmDataPermissionVo mdmDataPermissionVo);

    /**
     * 分页查询
     *
     * @param mdmDataPermissionExtendVo vo
     * @return page
     */
    PageResult<MdmDataPermissionExtendVo> findList(MdmDataPermissionExtendVo mdmDataPermissionExtendVo);

    /**
     * 已选职位分页列表
     *
     * @param mdmDataPermissionVo vo
     * @return page
     */
    PageResult<MdmPositionPageRespVo> relationPositionPageList(MdmDataPermissionVo mdmDataPermissionVo);

    /**
     * 未选职位分页列表
     *
     * @param mdmDataPermissionVo vo
     * @return page
     */
    PageResult<MdmPositionPageRespVo> unRelationPositionPageList(MdmDataPermissionVo mdmDataPermissionVo);
}

