package com.biz.crm.permission.service.impl;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionDetailVo;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionExtendVo;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionPageReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionPageRespVo;
import com.biz.crm.permission.mapper.MdmDataPermissionExtendMapper;
import com.biz.crm.permission.model.MdmDataPermissionExtendEntity;
import com.biz.crm.permission.service.IMdmDataPermissionExtendService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.util.List;

/**
 * 接口实现
 *
 * @author zxw
 * @date 2021-01-07 10:28:30
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmDataPermissionExtendServiceExpandImpl")
public class MdmDataPermissionExtendServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmDataPermissionExtendMapper, MdmDataPermissionExtendEntity> implements IMdmDataPermissionExtendService {

    @Autowired
    private MdmDataPermissionExtendMapper mdmDataPermissionExtendMapper;
    @Autowired
    private MdmPositionService mdmPositionService;

    @Override
    public void add(List<MdmDataPermissionExtendEntity> entityList) {
        if (!CollectionUtils.isEmpty(entityList)) {
            this.saveBatch(entityList);
        }
    }

    @Override
    public List<MdmDataPermissionDetailVo> listCondition(MdmDataPermissionVo mdmDataPermissionVo) {
        List<MdmDataPermissionExtendEntity> list = this.lambdaQuery()
                .eq(!StringUtils.isEmpty(mdmDataPermissionVo.getFunctionCode()), MdmDataPermissionExtendEntity::getFunctionCode, mdmDataPermissionVo.getFunctionCode())
                .eq(!StringUtils.isEmpty(mdmDataPermissionVo.getListConfigCode()), MdmDataPermissionExtendEntity::getListConfigCode, mdmDataPermissionVo.getListConfigCode())
                .eq(!StringUtils.isEmpty(mdmDataPermissionVo.getRoleCode()), MdmDataPermissionExtendEntity::getRoleCode, mdmDataPermissionVo.getRoleCode())
                .eq(!StringUtils.isEmpty(mdmDataPermissionVo.getEnableStatus()), MdmDataPermissionExtendEntity::getEnableStatus, mdmDataPermissionVo.getEnableStatus())
                .list();
        return CrmBeanUtil.copyList(list, MdmDataPermissionDetailVo.class);
    }

    @Override
    public PageResult<MdmDataPermissionExtendVo> findList(MdmDataPermissionExtendVo mdmDataPermissionExtendVo) {
        Page<MdmDataPermissionExtendVo> page = PageUtil.buildPage(mdmDataPermissionExtendVo.getPageNum(), mdmDataPermissionExtendVo.getPageSize());
        List<MdmDataPermissionExtendVo> list = mdmDataPermissionExtendMapper.findList(page, mdmDataPermissionExtendVo);
        return PageResult.<MdmDataPermissionExtendVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    public PageResult<MdmPositionPageRespVo> relationPositionPageList(MdmDataPermissionVo mdmDataPermissionVo) {
        Assert.hasText(mdmDataPermissionVo.getFunctionCode(), "菜单编码不能为空");
        Assert.hasText(mdmDataPermissionVo.getRoleCode(), "角色编码不能为空");
        Assert.hasText(mdmDataPermissionVo.getListConfigCode(), "列表编码不能为空");
        List<String> positionCodeList=mdmDataPermissionExtendMapper.findPositionCode(mdmDataPermissionVo);
        MdmPositionPageReqVo reqVo = new MdmPositionPageReqVo();
        reqVo.setPageNum(mdmDataPermissionVo.getPageNum());
        reqVo.setPageSize(mdmDataPermissionVo.getPageSize());
        reqVo.setIncludePositionCodeList(positionCodeList);
        return mdmPositionService.findList(reqVo);
    }

    @Override
    public PageResult<MdmPositionPageRespVo> unRelationPositionPageList(MdmDataPermissionVo mdmDataPermissionVo) {
        Assert.hasText(mdmDataPermissionVo.getFunctionCode(), "菜单编码不能为空");
        Assert.hasText(mdmDataPermissionVo.getRoleCode(), "角色编码不能为空");
        Assert.hasText(mdmDataPermissionVo.getListConfigCode(), "列表编码不能为空");
        List<String> positionCodeList=mdmDataPermissionExtendMapper.findPositionCode(mdmDataPermissionVo);
        MdmPositionPageReqVo reqVo = new MdmPositionPageReqVo();
        reqVo.setPageNum(mdmDataPermissionVo.getPageNum());
        reqVo.setPageSize(mdmDataPermissionVo.getPageSize());
        reqVo.setExcludePositionCodeList(positionCodeList);
        return mdmPositionService.findList(reqVo);
    }

}
