package com.biz.crm.poi.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.nebular.mdm.poi.req.MdmAmapPoiCityTreeReqVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmAmapPoiCityTreeRespVo;
import com.biz.crm.poi.service.MdmAmapPoiCityService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 高德POI
 *
 * @author Tao.Chen
 * @date 2021-05-10 22:44:52
 */
@Slf4j
@RestController
@RequestMapping("/mdmAmapPoiCityController")
@Api(tags = "MDM-高德地图城市")
@CrmGlobalLog
public class MdmAmapPoiCityController {

    @Resource
    private MdmAmapPoiCityService mdmAmapPoiCityService;

    @ApiOperation("懒加载树")
    @PostMapping("/lazyTree")
    public Result<List<MdmAmapPoiCityTreeRespVo>> lazyTree(@RequestBody MdmAmapPoiCityTreeReqVo reqVo) {
        return Result.ok(mdmAmapPoiCityService.lazyTree(reqVo));
    }

}
