package com.biz.crm.poi.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.poi.req.MdmAmapPoiDistanceReqVo;
import com.biz.crm.nebular.mdm.poi.req.MdmAmapPoiReqVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmAmapPoiDistanceRespVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmAmapPoiRespVo;
import com.biz.crm.poi.service.MdmAmapPoiAsyncService;
import com.biz.crm.poi.service.MdmAmapPoiService;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 高德POI
 *
 * @author Tao.Chen
 * @date 2021-05-10 22:44:52
 */
@Slf4j
@RestController
@RequestMapping("/mdmAmapPoiController")
@Api(tags = "MDM-高德地图POI")
@CrmGlobalLog
public class MdmAmapPoiController {

    @Resource
    private MdmAmapPoiService mdmAmapPoiService;
    @Resource
    private MdmAmapPoiAsyncService mdmAmapPoiAsyncService;

    @ApiOperation(value = "查询分页列表")
    @PostMapping("/findAmapPoiPageList")
    public Result<PageResult<MdmAmapPoiRespVo>> findAmapPoiPageList(@RequestBody MdmAmapPoiReqVo reqVo) {
        return Result.ok(mdmAmapPoiService.findAmapPoiList(reqVo));
    }

    @ApiOperation(value = "查询poi坐标距离分页列表")
    @PostMapping("/findAmapPoiDistancePageList")
    public Result<PageResult<MdmAmapPoiDistanceRespVo>> findAmapPoiDistancePageList(@RequestBody MdmAmapPoiDistanceReqVo reqVo) {
        return Result.ok(mdmAmapPoiService.findAmapPoiDistancePageList(reqVo));
    }

    @ApiOperation("查询高德地图POI数据")
    @PostMapping("/queryAndUpdate")
    public Result queryAndUpdate() {
        UserRedis user = UserUtils.getUser();
        String token = UserUtils.getToken();
        mdmAmapPoiAsyncService.queryAndUpdateAsync(token, user);
        return Result.ok();
    }

}
