package com.biz.crm.poi.service;

import com.biz.crm.nebular.mdm.poi.resp.MdmAmapDistrictRespVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmAmapDistrictStatisticianRespVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmTerminalStatisticianTypeTotalVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmAmapDistrictStatisticianReqVo;

import java.util.List;

public interface MdmAmapStatisticianService {
    /**
     * 查询已合作客户类型统计
     * @return vo
     */
    void statisticalType(MdmTerminalStatisticianTypeTotalVo result);

    /**
     * 查询已合作客户或终端区域统计
     * @param mdmAmapDistrictStatisticianReqVo vo
     * @return list
     */
    List<MdmAmapDistrictStatisticianRespVo> statisticalDistrict(MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo);

    /**
     * 查询未合作客户或终端类型统计
     * @return list
     */
    void unCooperationStatisticalType(MdmTerminalStatisticianTypeTotalVo result);

    /**
     * 查询未合作区域统计
     * @param mdmAmapDistrictStatisticianReqVo vo
     * @return list
     */
    List<MdmAmapDistrictStatisticianRespVo> unCooperationStatisticalDistrict(MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo);

    List<MdmAmapDistrictRespVo> district(MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo);

    /**
     * 查询未合作的打点统计
     * @param mdmAmapDistrictStatisticianReqVo
     * @return list
     */
    List<MdmAmapDistrictRespVo> unCooperationDistrict(MdmAmapDistrictStatisticianReqVo mdmAmapDistrictStatisticianReqVo);

    /**
     * 查询查询所有类型统计
     * @return vo
     */
    MdmTerminalStatisticianTypeTotalVo statisticalTotal();
}
