package com.biz.crm.poi.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.base.config.ThreadLocalUtil;
import com.biz.crm.common.GlobalParam;
import com.biz.crm.gaode.vo.AmapPoiQueryReqVo;
import com.biz.crm.gaode.vo.AmapPoiResultVo;
import com.biz.crm.gaode.vo.AmapPoiVo;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.biz.crm.nebular.mdm.constant.RegionLevelEnum;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.poi.mapper.MdmAmapPoiElasticsearchRepository;
import com.biz.crm.poi.model.MdmAmapPoiCityEntity;
import com.biz.crm.poi.model.MdmAmapPoiEntity;
import com.biz.crm.poi.model.MdmAmapPoiPhotoEntity;
import com.biz.crm.poi.model.MdmAmapPoiProcessEntity;
import com.biz.crm.poi.service.*;
import com.biz.crm.sfa.map.GaoDeFeign;
import com.biz.crm.util.*;
import com.biz.crm.utils.MdmConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmAmapPoiAsyncServiceExpandImpl")
public class MdmAmapPoiAsyncServiceImpl implements MdmAmapPoiAsyncService {

    @Resource
    private MdmAmapPoiService mdmAmapPoiService;
    @Resource
    private MdmAmapPoiPhotoService mdmAmapPoiPhotoService;
    @Resource
    private MdmAmapPoiProcessService mdmAmapPoiProcessService;
    @Resource
    private MdmAmapPoiCityService mdmAmapPoiCityService;
    @Resource
    private MdmAmapPoiTypeService mdmAmapPoiTypeService;
    @Resource
    private GaoDeFeign gaoDeFeign;
    @Resource
    private ElasticsearchTemplate elasticsearchTemplate;
    @Resource
    private MdmAmapPoiElasticsearchRepository elasticsearchRepository;

    private static Boolean createIndex = false;

    @Override
    @Async
    public void queryAndUpdateAsync(String token, UserRedis user) {

        if (StringUtils.isNotEmpty(token)) {
            ConcurrentHashMap<String, Object> map = ThreadLocalUtil.get();
            if (map == null) {
                map = new ConcurrentHashMap<>(16);
            }
            map.put(GlobalParam.TOKEN, token);
            ThreadLocalUtil.stObj(map);
        }
        if (user != null) {
            ThreadLocalUtil.setUser(user);
        }

        //获取要查询的城市
        List<String> cityList = mdmAmapPoiCityService.getCityList();
        if (CollectionUtil.listEmpty(cityList)) {
            log.info("高德地图POI=====>>没有要抓取的城市数据");
            return;
        }

        //获取要查询的类别
        List<String> typeList = mdmAmapPoiTypeService.getTypeList();
        if (CollectionUtil.listEmpty(typeList)) {
            log.info("高德地图POI=====>>没有要抓取的POI分类数据");
            return;
        }

        //获取要查询的关键字
//        List<String> keywordList = this.getKeywordList();
//        if (CollectionUtil.listEmpty(keywordList)) {
//            log.info("高德地图POI=====>>没有要抓取的关键字数据");
//            return;
//        }

        Set<String> processSet = mdmAmapPoiProcessService.getProcessList();
        Map<String, MdmAmapPoiCityEntity> cityEntityMap = new HashMap<>(16);

//        int totalSize = cityList.size() * typeList.size() * keywordList.size();
        int totalSize = cityList.size() * typeList.size();
        int i = 0;
        for (String cityCode :
                cityList) {
            for (String typeCode :
                    typeList) {
//                for (String keyword :
//                        keywordList) {
                i++;

                boolean flag = this.queryAmapPoiAndSave(processSet, cityEntityMap, cityCode, typeCode, "");
                if (flag) {
                    return;
                }

                if (i >= totalSize) {
                    //结束
                    mdmAmapPoiProcessService.deleteAllProcess();
                }

//                }
            }
        }

    }

    protected boolean queryAmapPoiAndSave(Set<String> set, Map<String, MdmAmapPoiCityEntity> cityEntityMap, String cityCode, String typeCode, String keyword) {
        String key = cityCode + "_" + typeCode + "_" + keyword;
        if (set.contains(key)) {
            return false;
        }
        try {

            log.info("高德地图POI=====>>抓取数据：cityCode：{}，typeCode：{}，keyword：{}", cityCode, typeCode, keyword);

            int page = 1;
            int offset = 25;
            boolean endBreak = true;

            while (true) {
                endBreak = true;
                AmapPoiQueryReqVo reqVo = new AmapPoiQueryReqVo();
                reqVo.setCitylimit(true);
                reqVo.setCity(cityCode);
                reqVo.setTypes(typeCode);
                reqVo.setKeywords(keyword);
                reqVo.setPage(String.valueOf(page));
                reqVo.setOffset(String.valueOf(offset));
                Result<AmapPoiResultVo> result = gaoDeFeign.queryKeywords(reqVo);
                if (result.isSuccess()) {
                    AmapPoiResultVo poiResultVo = result.getResult();
                    if ("1".equals(poiResultVo.getStatus())) {
                        List<AmapPoiVo> pois = poiResultVo.getPois();
                        if (CollectionUtil.listNotEmptyNotSizeZero(pois)) {
                            log.info("高德地图POI=====>>当前条件共有数据：{} 条，共 {} 页，当前页码：{}，本页：{} 条", poiResultVo.getCount(), new BigDecimal(poiResultVo.getCount()).divide(new BigDecimal(offset), 0, BigDecimal.ROUND_UP), page, pois.size());
                            if (((page - 1) * offset + pois.size()) < Integer.valueOf(poiResultVo.getCount())) {
                                endBreak = false;
                                page++;
                            }
                            final Set<String> existAmapId = mdmAmapPoiService.lambdaQuery()
                                    .in(MdmAmapPoiEntity::getAmapId, pois.stream().map(AmapPoiVo::getId).collect(Collectors.toList()))
                                    .select(MdmAmapPoiEntity::getAmapId)
                                    .list().stream().map(MdmAmapPoiEntity::getAmapId).collect(Collectors.toSet());


                            Set<String> amapCodeSet = pois.stream().filter(x -> StringUtils.isNotEmpty(x.getAdcode()) && !cityEntityMap.containsKey(x.getAdcode())).map(AmapPoiVo::getAdcode).collect(Collectors.toSet());
                            if (!amapCodeSet.isEmpty()) {
                                cityEntityMap.putAll(mdmAmapPoiCityService.lambdaQuery()
                                        .eq(MdmAmapPoiCityEntity::getRegionLevel, RegionLevelEnum.COUNTY.getCode())
                                        .in(MdmAmapPoiCityEntity::getAmapCode, amapCodeSet)
                                        .list()
                                        .stream().collect(Collectors.toMap(MdmAmapPoiCityEntity::getAmapCode, v -> v)));
                            }

                            List<MdmAmapPoiEntity> collect = pois.stream().map(x -> {
//                            MdmAmapPoiEntity copy = new MdmAmapPoiEntity();
                                MdmAmapPoiEntity copy = CrmBeanUtil.copy(x, MdmAmapPoiEntity.class);
                                copy.setId(x.getId());
                                copy.setAmapId(x.getId());
                                copy.setParentAmapId(x.getParent());
                                copy.setPoiName(x.getName());
                                copy.setTypeName(x.getType());
                                copy.setTypeCode(x.getTypecode());
                                copy.setBizType(x.getBiz_type());
                                copy.setAddress(x.getAddress());
                                if (StringUtils.isNotEmpty(x.getLocation())) {
                                    copy.setLongitude(x.getLocation().substring(0, x.getLocation().indexOf(",")));
                                    copy.setLatitude(x.getLocation().substring(x.getLocation().indexOf(",") + 1));
                                    copy.setLocation(copy.getLatitude() + "," + copy.getLongitude());
                                }
                                copy.setDistance(x.getDistance());
                                copy.setTel(x.getTel());
                                copy.setPostCode(x.getPostcode());
                                copy.setWebsite(x.getWebsite());
                                copy.setEmail(x.getEmail());
                                copy.setAmapProvinceCode(x.getPcode());
                                copy.setAmapProvinceName(x.getPname());
                                if (StringUtils.isNotEmpty(x.getAdcode())) {
                                    if (cityEntityMap.containsKey(x.getAdcode())) {
                                        MdmAmapPoiCityEntity cityEntity = cityEntityMap.get(x.getAdcode());
                                        copy.setAmapCityCode(cityEntity.getParentCode());
                                        copy.setRegionCode(cityEntity.getRegionCode());
                                    }
                                }
                                copy.setAmapCityName(x.getCityname());
                                copy.setAmapDistrictCode(x.getAdcode());
                                copy.setAmapDistrictName(x.getAdname());
                                if (StringUtils.isNotEmpty(x.getEntr_location())) {
                                    copy.setEntrLongitude(x.getEntr_location().substring(0, x.getEntr_location().indexOf(",")));
                                    copy.setEntrLatitude(x.getEntr_location().substring(x.getEntr_location().indexOf(",") + 1));
                                    copy.setEntrLocation(copy.getEntrLatitude() + "," + copy.getEntrLongitude());
                                }
                                copy.setNaviPoiid(x.getNavi_poiid());
                                copy.setGridCode(x.getGridcode());
                                copy.setAlias(x.getAlias());
                                copy.setBusinessArea(x.getBusiness_area());
                                copy.setTag(x.getTag());
                                if (CollectionUtil.listNotEmptyNotSizeZero(x.getPhotos())) {
                                    copy.setPoiPhoto(x.getPhotos().get(0).getUrl());
                                }
                                return copy;
                            }).collect(Collectors.toList());

                            if (CollectionUtil.listNotEmptyNotSizeZero(collect)) {
                                List<MdmAmapPoiEntity> saveBatch = collect.stream().filter(x -> !existAmapId.contains(x.getAmapId())).collect(Collectors.toList());
                                if (CollectionUtil.listNotEmptyNotSizeZero(saveBatch)) {
                                    mdmAmapPoiService.saveBatch(saveBatch);
                                }
                                List<MdmAmapPoiEntity> updateBatch = collect.stream().filter(x -> existAmapId.contains(x.getAmapId())).collect(Collectors.toList());
                                if (CollectionUtil.listNotEmptyNotSizeZero(updateBatch)) {
                                    mdmAmapPoiService.updateBatchById(updateBatch);
                                }
                                this.saveToElasticsearch(collect);

                                mdmAmapPoiPhotoService.lambdaUpdate()
                                        .in(MdmAmapPoiPhotoEntity::getAmapId, collect.stream().map(MdmAmapPoiEntity::getAmapId).collect(Collectors.toSet()))
                                        .remove();

                                List<MdmAmapPoiPhotoEntity> photos = pois.stream().flatMap(x -> x.getPhotos().stream().map(y -> {
                                    MdmAmapPoiPhotoEntity photo = new MdmAmapPoiPhotoEntity();
                                    photo.setAmapId(x.getId());
                                    photo.setTitile(y.getTitile());
                                    photo.setUrl(y.getUrl());
                                    return photo;
                                })).collect(Collectors.toList());
                                if (CollectionUtil.listNotEmptyNotSizeZero(photos)) {
                                    mdmAmapPoiPhotoService.saveBatch(photos);
                                }
                                this.saveToOtherPlace(collect, photos);
                            }
                        }
                    } else {

                        // DAILY_QUERY_OVER_LIMIT     访问已超出日访问量
                        // ACCESS_TOO_FREQUENT     单位时间内访问过于频繁

                        log.info("高德地图POI=====>>抓取数据失败：错误编码：{}", poiResultVo.getInfo());
                        if ("DAILY_QUERY_OVER_LIMIT".equals(poiResultVo.getInfo())) {
                            log.info("高德地图POI=====>>访问已超出日访问量");
                            return true;
                        }
                        if ("USER_DAILY_QUERY_OVER_LIMIT".equals(poiResultVo.getInfo())) {
                            log.info("高德地图POI=====>>账号维度日调用量超出限制");
                            return true;
                        }
                        if ("INVALID_REQUEST".equals(poiResultVo.getInfo())) {
                            log.info("高德地图POI=====>>账号处于被封禁状态");
                            return true;
                        }
                        if ("ACCESS_TOO_FREQUENT".equals(poiResultVo.getInfo())) {
                            log.info("高德地图POI=====>>单位时间内访问过于频繁");
                            Thread.sleep(1000L * 15);
                        }
                    }
                } else {
                    throw new BusinessException("高德地图POI=====>>请求失败：{}" + result.getMessage());
                }

                if (endBreak) {
                    break;
                }
            }
            MdmAmapPoiProcessEntity entity = new MdmAmapPoiProcessEntity();
            entity.setCityCode(cityCode);
            entity.setPoiType(typeCode);
            entity.setPoiKeyword(keyword);
            mdmAmapPoiProcessService.save(entity);
            set.add(key);
        } catch (Exception e) {
            log.error("高德地图POI=====>>抓取数据异常：cityCode：{}，typeCode：{}，keyword：{}，异常信息：{}", cityCode, typeCode, keyword, e);
            e.printStackTrace();
        }
        return false;
    }

    protected void saveToElasticsearch(List<MdmAmapPoiEntity> list) {
        if (!createIndex) {
            if (!elasticsearchTemplate.indexExists(MdmConstant.MDM_AMAP_POI_INDEX)) {
                elasticsearchTemplate.createIndex(MdmAmapPoiEntity.class);
            }
            createIndex = true;
        }
        elasticsearchRepository.saveAll(list);
    }

    protected void saveToOtherPlace(List<MdmAmapPoiEntity> list, List<MdmAmapPoiPhotoEntity> photos) {

    }

    protected List<String> getKeywordList() {
        return DictUtil.list(DictConstant.MDM_AMAP_POI_KEYWORD).stream().map(DictDataVo::getDictValue).distinct().collect(Collectors.toList());
    }

}

