package com.biz.crm.poi.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.poi.mapper.MdmAmapPoiProcessMapper;
import com.biz.crm.poi.model.MdmAmapPoiProcessEntity;
import com.biz.crm.poi.service.MdmAmapPoiProcessService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 高德poi数据抓取进度表接口实现
 *
 * @author Tao.Chen
 * @date 2021-05-07 22:24:48
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmAmapPoiProcessServiceExpandImpl")
public class MdmAmapPoiProcessServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmAmapPoiProcessMapper, MdmAmapPoiProcessEntity> implements MdmAmapPoiProcessService {

    @Resource
    private MdmAmapPoiProcessMapper mdmAmapPoiProcessMapper;

    @Override
    public void deleteAllProcess() {
        mdmAmapPoiProcessMapper.truncateTable();
    }

    public Set<String> getProcessList() {
        return this.lambdaQuery()
                .select(MdmAmapPoiProcessEntity::getCityCode, MdmAmapPoiProcessEntity::getPoiType, MdmAmapPoiProcessEntity::getPoiKeyword)
                .list()
                .stream().map(x -> x.getCityCode() + "_" + x.getPoiType() + "_" + x.getPoiKeyword()).collect(Collectors.toSet());
    }

}
