package com.biz.crm.poi.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.constant.DictConstant;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.nebular.mdm.poi.req.MdmAmapPoiTypeTreeReqVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmAmapPoiTypeTreeRespVo;
import com.biz.crm.poi.mapper.MdmAmapPoiTypeMapper;
import com.biz.crm.poi.model.MdmAmapPoiTypeEntity;
import com.biz.crm.poi.service.MdmAmapPoiTypeService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmAmapPoiTypeServiceExpandImpl")
public class MdmAmapPoiTypeServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmAmapPoiTypeMapper, MdmAmapPoiTypeEntity> implements MdmAmapPoiTypeService {

    @Resource
    private MdmAmapPoiTypeMapper mdmAmapPoiTypeMapper;

    @Override
    public List<MdmAmapPoiTypeTreeRespVo> lazyTree(MdmAmapPoiTypeTreeReqVo reqVo) {
        List<MdmAmapPoiTypeTreeRespVo> list = new ArrayList<>();
        if (StringUtils.isEmpty(reqVo.getParentCode())) {
            list = mdmAmapPoiTypeMapper.findFirstLevel();
        } else {
            list = mdmAmapPoiTypeMapper.findListByParentCode(reqVo);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> item.setHasChild(YesNoEnum.yesNoEnum.ONE.getValue().equalsIgnoreCase(String.valueOf(item.getHasChildFlag()))));
        }
        return list;
    }

    @Override
    public List<String> getTypeList() {
        Set<String> set = new HashSet<>(16);
        List<DictDataVo> dictList = DictUtil.list(DictConstant.MDM_AMAP_POI_TYPE);
        if (CollectionUtil.listNotEmptyNotSizeZero(dictList)) {
            List<MdmAmapPoiTypeEntity> list = this.lambdaQuery()
                    .in(MdmAmapPoiTypeEntity::getTypeCode, dictList.stream().map(DictDataVo::getDictCode).collect(Collectors.toSet()))
                    .select(MdmAmapPoiTypeEntity::getTypeCode, MdmAmapPoiTypeEntity::getParentCode)
                    .list();
            if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
                final Set<String> existParentCodeSet = list.stream().filter(x -> StringUtils.isNotEmpty(x.getParentCode())).map(MdmAmapPoiTypeEntity::getParentCode).collect(Collectors.toSet());
                List<MdmAmapPoiTypeEntity> collect = list.stream().filter(x -> !existParentCodeSet.contains(x.getTypeCode())).collect(Collectors.toList());
                if (CollectionUtil.listNotEmptyNotSizeZero(collect)) {
                    this.getTypeChildren(set, collect);
                }
            }
        }
        return new ArrayList<>(set);
    }

    protected void getTypeChildren(Set<String> set, List<MdmAmapPoiTypeEntity> list) {
        if (CollectionUtil.listEmpty(list)) {
            return;
        }
        Set<String> listCodeSet = list.stream().map(MdmAmapPoiTypeEntity::getTypeCode).collect(Collectors.toSet());
        List<MdmAmapPoiTypeEntity> listChildren = this.lambdaQuery()
                .in(MdmAmapPoiTypeEntity::getParentCode, listCodeSet)
                .select(MdmAmapPoiTypeEntity::getTypeCode, MdmAmapPoiTypeEntity::getParentCode)
                .list();
        if (CollectionUtil.listNotEmptyNotSizeZero(listChildren)) {
            final Set<String> listChildrenParentCodeSet = listChildren.stream().filter(x -> StringUtils.isNotEmpty(x.getParentCode())).map(MdmAmapPoiTypeEntity::getParentCode).collect(Collectors.toSet());
            set.addAll(listCodeSet.stream().filter(x -> !listChildrenParentCodeSet.contains(x)).collect(Collectors.toSet()));
            this.getTypeChildren(set, listChildren);
        } else {
            set.addAll(listCodeSet);
        }
    }

}
