package com.biz.crm.position.controller;

import com.biz.crm.nebular.mdm.position.resp.MdmPositionParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRedisVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionReloadRedisVo;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.util.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 职位表
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Slf4j
@RestController
@RequestMapping("/mdmPositionRedisController")
public class MdmPositionRedisController {

    @Autowired
    private MdmPositionService mdmPositionService;

    /**
     * 根据职位编码集合获取职位详情redis缓存数据
     *
     * @param orgCodeList 职位编码集合
     * @return
     */
    @PostMapping("/findRedisListByPositionCodeList")
    public Result<List<MdmPositionRedisVo>> findRedisListByPositionCodeList(@RequestBody List<String> orgCodeList) {
        return Result.ok(mdmPositionService.findRedisListByPositionCodeList(orgCodeList));
    }

    /**
     * 根据职位编码集合获取职位上级redis缓存数据
     *
     * @param orgCodeList 职位编码集合
     * @return
     */
    @PostMapping("/findRedisPositionParentListByCodeList")
    public Result<List<MdmPositionParentChildrenRedisVo>> findRedisPositionParentListByCodeList(@RequestBody List<String> orgCodeList) {
        return Result.ok(mdmPositionService.findRedisPositionParentListByCodeList(orgCodeList));
    }

    /**
     * 根据职位编码集合获取职位下级redis缓存数据
     *
     * @param orgCodeList 职位编码集合
     * @return
     */
    @PostMapping("/findRedisPositionChildrenListByCodeList")
    public Result<List<MdmPositionParentChildrenRedisVo>> findRedisPositionChildrenListByCodeList(@RequestBody List<String> orgCodeList) {
        return Result.ok(mdmPositionService.findRedisPositionChildrenListByCodeList(orgCodeList));
    }

    /**
     * 获取全部职位redis缓存数据
     *
     * @return
     */
    @PostMapping("/findRedisReloadList")
    public Result<List<MdmPositionReloadRedisVo>> findRedisReloadList() {
        return Result.ok(mdmPositionService.findRedisReloadList());
    }

}
