package com.biz.crm.position.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.position.req.MdmPositionRelationCustomerPageReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionRelationCustomerReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRelationCustomerPageRespVo;
import com.biz.crm.position.service.MdmPositionRelationCustomerService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Slf4j
@RestController
@RequestMapping("/mdmPositionRelationCustomerController")
@Api(tags = "MDM-职位管理-关联客户")
@CrmGlobalLog
public class MdmPositionRelationCustomerController {

    @Autowired
    private MdmPositionRelationCustomerService mdmPositionRelationCustomerService;

    @ApiOperation(value = "查询未关联任何职位的客户")
    @PostMapping("/findCustomerNotRelateAnyPosition")
    @CrmDictMethod
    public Result<PageResult<MdmPositionRelationCustomerPageRespVo>> findCustomerNotRelateAnyPosition(@RequestBody MdmPositionRelationCustomerPageReqVo reqVo) {
        return Result.ok(mdmPositionRelationCustomerService.findCustomerNotRelateAnyPosition(reqVo));
    }

    @ApiOperation(value = "查询未关联当前职位的客户", notes = "positionCode必传")
    @PostMapping("/findCustomerNotRelateCurPosition")
    @CrmDictMethod
    public Result<PageResult<MdmPositionRelationCustomerPageRespVo>> findCustomerNotRelateCurPosition(@RequestBody MdmPositionRelationCustomerPageReqVo reqVo) {
        return Result.ok(mdmPositionRelationCustomerService.findCustomerNotRelateCurPosition(reqVo));
    }

    @ApiOperation(value = "查询已关联当前用户的客户", notes = "positionCode必传")
    @PostMapping("/findCustomerHasRelateCurPosition")
    @CrmDictMethod
    public Result<PageResult<MdmPositionRelationCustomerPageRespVo>> findCustomerHasRelateCurPosition(@RequestBody MdmPositionRelationCustomerPageReqVo reqVo) {
        return Result.ok(mdmPositionRelationCustomerService.findCustomerHasRelateCurPosition(reqVo));
    }

    @ApiOperation(value = "添加客户与职位的关联", notes = "传customerCodeList和positionCode")
    @PostMapping("/bindRelation")
    public Result bindRelation(@RequestBody MdmPositionRelationCustomerReqVo reqVo) {
        mdmPositionRelationCustomerService.bindRelation(reqVo.getCustomerCodeList(), reqVo.getPositionCode());
        return Result.ok();
    }

    @ApiOperation(value = "替换关联职位", notes = "传ids和positionCode")
    @PostMapping("/replaceCustomerPosition")
    public Result replaceCustomerPosition(@RequestBody MdmPositionRelationCustomerReqVo reqVo) {
        mdmPositionRelationCustomerService.replaceCustomerPosition(reqVo.getIds(), reqVo.getPositionCode());
        return Result.ok();
    }

    @ApiOperation(value = "解除客户与职位关联关系", notes = "传ids", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "关联关系id集合", required = true, paramType = "body")
    })
    @PostMapping("/unbindRelation")
    public Result unbindRelation(@RequestBody List<String> ids) {
        mdmPositionRelationCustomerService.unbindRelation(ids);
        return Result.ok();
    }

}
