package com.biz.crm.position.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.position.req.MdmPositionRelationTerminalPageReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionRelationTerminalReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRelationTerminalPageRespVo;
import com.biz.crm.position.service.MdmPositionRelationTerminalService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Slf4j
@RestController
@RequestMapping("/mdmPositionRelationTerminalController")
@Api(tags = "MDM-职位管理-关联终端")
@CrmGlobalLog
public class MdmPositionRelationTerminalController {

    @Autowired
    private MdmPositionRelationTerminalService mdmPositionRelationTerminalService;

    @ApiOperation(value = "查询未关联任何职位的终端")
    @PostMapping("/findTerminalNotRelateAnyPosition")
    @CrmDictMethod
    public Result<PageResult<MdmPositionRelationTerminalPageRespVo>> findTerminalNotRelateAnyPosition(@RequestBody MdmPositionRelationTerminalPageReqVo reqVo) {
        return Result.ok(mdmPositionRelationTerminalService.findTerminalNotRelateAnyPosition(reqVo));
    }

    @ApiOperation(value = "查询未关联当前职位的终端", notes = "positionCode必传")
    @PostMapping("/findTerminalNotRelateCurPosition")
    @CrmDictMethod
    public Result<PageResult<MdmPositionRelationTerminalPageRespVo>> findTerminalNotRelateCurPosition(@RequestBody MdmPositionRelationTerminalPageReqVo reqVo) {
        return Result.ok(mdmPositionRelationTerminalService.findTerminalNotRelateCurPosition(reqVo));
    }

    @ApiOperation(value = "查询已关联当前职位的终端", notes = "positionCode必传")
    @PostMapping("/findTerminalHasRelateCurPosition")
    @CrmDictMethod
    public Result<PageResult<MdmPositionRelationTerminalPageRespVo>> findTerminalHasRelateCurPosition(@RequestBody MdmPositionRelationTerminalPageReqVo reqVo) {
        return Result.ok(mdmPositionRelationTerminalService.findTerminalHasRelateCurPosition(reqVo));
    }

    @ApiOperation(value = "添加职位与终端的关联", notes = "传（terminalCodeList、positionCode）")
    @PostMapping("/bindRelation")
    public Result bindRelation(@RequestBody MdmPositionRelationTerminalReqVo reqVo) {
        mdmPositionRelationTerminalService.bindRelation(reqVo.getTerminalCodeList(), reqVo.getPositionCode());
        return Result.ok();
    }

    @ApiOperation(value = "替换终端上关联职位", notes = "传（ids、positionCode）")
    @PostMapping("/replaceTerminalPosition")
    public Result replaceTerminalPosition(@RequestBody MdmPositionRelationTerminalReqVo reqVo) {
        mdmPositionRelationTerminalService.replaceTerminalPosition(reqVo.getIds(), reqVo.getPositionCode());
        return Result.ok();
    }

    @ApiOperation(value = "解除职位与终端的关联", notes = "传关联表id集合", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "关联关系id集合", required = true, paramType = "body")
    })
    @PostMapping("/unbindRelation")
    public Result unbindRelation(@RequestBody List<String> ids) {
        mdmPositionRelationTerminalService.unbindRelation(ids);
        return Result.ok();
    }

}
