package com.biz.crm.position.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionPositionVo;
import com.biz.crm.nebular.mdm.position.req.*;
import com.biz.crm.nebular.mdm.position.resp.*;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.provider.MdmPositionProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

import java.util.List;

/**
 * 职位表
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
public interface MdmPositionMapper extends BaseMapper<MdmPositionEntity> {

    /**
     * 列表
     *
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(posCode = "b10.position_code",orgCode = "b10.org_code")
    List<MdmPositionPageRespVo> findList(Page<MdmPositionPageRespVo> page, @Param("vo") MdmPositionPageReqVo reqVo);

    /**
     * 列表(provider)
     *
     * @param page
     * @param reqVo
     * @return
     */
    @SelectProvider(type = MdmPositionProvider.class,method = "findListProvider")
    @SqlPrivilege(posCode = "b10.position_code")
    List<MdmPositionPageRespVo> findListProvider(Page<MdmPositionPageRespVo> page, @Param("vo") MdmPositionPageReqVo reqVo);




    /**
     * 根据职位编码查询职位关联信息
     *
     * @param mdmPositionReqVo
     * @return
     */
    List<MdmPositionRespVo> findPositionRelation(@Param("vo") MdmPositionReqVo mdmPositionReqVo);

    /**
     * 查询职位下拉框列表
     *
     * @param page
     * @param reqVo
     * @param transportVo
     * @return
     */
    @SqlPrivilege(posCode = "c10.position_code",orgCode = "c10.org_code")
    List<MdmPositionSelectRespVo> findPositionSelectList(Page<MdmPositionSelectRespVo> page, @Param("vo") MdmPositionSelectReqVo reqVo, @Param("transportVo") MdmPositionSelectTransportReqVo transportVo);

    /**
     * 查询以职位维度的职位及关联用户、组织、上级信息
     *
     * @param page
     * @param reqVo
     * @return
     */
    /// TODO 登录的时候传了菜单编码和功能编码会有问题，先去掉权限过滤
//    @SqlPrivilege(posCode = "c10.position_code",orgCode = "c10.org_code")
    List<MdmPositionUserOrgRespVo> findPositionUserOrgList(Page<MdmPositionUserOrgRespVo> page, @Param("vo") MdmPositionUserOrgReqVo reqVo);

    /**
     * 查询以职位维度的职位及关联用户、组织、上级信息(分页)，部分字段为模糊查询，一般用于以职位为主体的弹框
     *
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(posCode = "c10.position_code",orgCode = "c10.org_code")
    List<MdmPositionUserOrgPageRespVo> findPositionUserOrgPageList(Page<MdmPositionUserOrgPageRespVo> page, @Param("vo") MdmPositionUserOrgPageReqVo reqVo);


    /**
     * 根据流程角色编码和组织编码集合查询职位
     *
     * @param delFlag
     * @param enableStatus
     * @param bpmRoleCode
     * @param orgCodeList
     * @return
     */
    List<MdmPositionUserOrgRespVo> findPositionListByBpmRole(@Param("delFlag") String delFlag, @Param("enableStatus") String enableStatus, @Param("bpmRoleCode") String bpmRoleCode, @Param("orgCodeList") List<String> orgCodeList);

    /**
     * 查询职位下级
     *
     * @param page
     * @param reqVo            查询参数
     * @param positionCodeList 当前层级职位编码（必传）
     * @return
     */
    @SqlPrivilege(posCode = "c1.position_code",orgCode = "c1.org_code")
    List<MdmPositionUnderlingRespVo> findPositionUnderlingList(Page<MdmPositionUnderlingRespVo> page, @Param("vo") MdmPositionUnderlingReqVo reqVo, @Param("positionCodeList") List<String> positionCodeList);

    /**
     * 查询下属选择上级职位选择列表
     *
     * @param page
     * @param reqVo
     * @param excludeOrgCodeList
     * @return
     */
    @SqlPrivilege(posCode = "c10.position_code",orgCode = "c10.org_code")
    List<MdmPositionUserOrgPageRespVo> findPositionUnderlingParentSelectPageList(Page<MdmPositionUserOrgPageRespVo> page, @Param("vo") MdmPositionUnderlingParentSelectReqVo reqVo, @Param("excludeOrgCodeList") List<String> excludeOrgCodeList);

    /**
     * 根据降维编码集合查询职位下级
     *
     * @param reqVo
     * @param likeRightRuleCodeList
     * @return
     */
    List<MdmPositionRespVo> findPositionChildrenByRuleCodeList(@Param("vo") MdmPositionReqVo reqVo, @Param("likeRightRuleCodeList") List<String> likeRightRuleCodeList);

    /**
     * 把职位表的降维编码刷成id
     */
    void copyIdToRuleCode();

    /**
     * 把不存在的上级编码置成空
     */
    void setNullNotExistParentCode();

    /**
     * 查询职位对应的组织与用户
     * @param positionCodeList 职位编码集合
     * @return list
     */
    @SqlPrivilege(posCode = "c.position_code",orgCode = "b.org_code")
    List<MdmDataPermissionPositionVo> findPositionAndOrgList(@Param("vo") List<String> positionCodeList);

    /**
     * 查询职位详情
     * @param id id
     * @param positionCode 职位编码
     * @return
     */
    MdmPositionRespVo detail(@Param("id") String id,@Param("positionCode") String positionCode);

    /**
     * 职位与用户分页列表
     * @param page page
     * @param reqVo vo
     * @return page
     */
    @SqlPrivilege(posCode = "a.position_code",orgCode = "d.org_code")
    List<MdmPositionPageRespVo> positionAndUserPage(Page<MdmPositionPageRespVo> page,@Param("vo") MdmPositionCurrentUserReqVo reqVo);

    /**
     * 根据组织和流程角色编码查询启用的职位编码
     *
     * @param orgCodeList     组织编码集合
     * @param orgRuleCodeList 组织降维编码集合
     * @param bpmRoleCodeList 流程角色编码集合（必填）
     * @return
     */
    List<String> findPositionCodeListByOrgListAndBpmRoleList(@Param("orgCodeList") List<String> orgCodeList, @Param("orgRuleCodeList") List<String> orgRuleCodeList, @Param("bpmRoleCodeList") List<String> bpmRoleCodeList);

    /**
     * 查询职位缓存数据
     * @param positionCodeList
     * @return
     */
    List<MdmPositionRedisVo> findRedisListByPositionCodeList(@Param("positionCodeList") List<String> positionCodeList);
}
