package com.biz.crm.position.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.nebular.mdm.position.req.MdmPositionRelationTerminalPageReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRelationTerminalPageRespVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

public interface MdmPositionRelationTerminalMapper {

    /**
     * 查询未关联任何职位的终端
     *
     * @param page
     * @param reqVo
     * @return
     */
    List<MdmPositionRelationTerminalPageRespVo> findTerminalNotRelateAnyPosition(Page<MdmPositionRelationTerminalPageRespVo> page, @Param("vo") MdmPositionRelationTerminalPageReqVo reqVo);

    /**
     * 查询未关联当前职位的终端
     *
     * @param page
     * @param reqVo
     * @return
     */
    List<MdmPositionRelationTerminalPageRespVo> findTerminalNotRelateCurPosition(Page<MdmPositionRelationTerminalPageRespVo> page, @Param("vo") MdmPositionRelationTerminalPageReqVo reqVo);

    /**
     * 查询已关联当前职位的终端
     *
     * @param page
     * @param reqVo
     * @return
     */
    List<MdmPositionRelationTerminalPageRespVo> findTerminalHasRelateCurPosition(Page<MdmPositionRelationTerminalPageRespVo> page, @Param("vo") MdmPositionRelationTerminalPageReqVo reqVo);

}
