package com.biz.crm.position.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.position.req.MdmPositionRelationCustomerPageReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRelationCustomerPageRespVo;

import java.util.List;

public interface MdmPositionRelationCustomerService {

    /**
     * 查询未关联任何用户的客户
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmPositionRelationCustomerPageRespVo> findCustomerNotRelateAnyPosition(MdmPositionRelationCustomerPageReqVo reqVo);

    /**
     * 查询为关联当前用户的客户
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmPositionRelationCustomerPageRespVo> findCustomerNotRelateCurPosition(MdmPositionRelationCustomerPageReqVo reqVo);

    /**
     * 查询已关联当前用户的客户
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmPositionRelationCustomerPageRespVo> findCustomerHasRelateCurPosition(MdmPositionRelationCustomerPageReqVo reqVo);

    /**
     * 绑定客户和职位
     *
     * @param customerCodeList
     * @param positionCode
     */
    void bindRelation(List<String> customerCodeList, String positionCode);

    /**
     * 替换客户绑定的职位
     *
     * @param ids
     * @param positionCode
     */
    void replaceCustomerPosition(List<String> ids, String positionCode);

    /**
     * 解绑关联关系
     *
     * @param ids
     */
    void unbindRelation(List<String> ids);

}
