package com.biz.crm.position.service;

import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.position.req.MdmPositionRelationTerminalPageReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRelationTerminalPageRespVo;

import java.util.List;

public interface MdmPositionRelationTerminalService {

    /**
     * 查询未关联任何职位的终端
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmPositionRelationTerminalPageRespVo> findTerminalNotRelateAnyPosition(MdmPositionRelationTerminalPageReqVo reqVo);

    /**
     * 查询未关联当前职位的终端
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmPositionRelationTerminalPageRespVo> findTerminalNotRelateCurPosition(MdmPositionRelationTerminalPageReqVo reqVo);

    /**
     * 查询已关联当前职位的终端
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmPositionRelationTerminalPageRespVo> findTerminalHasRelateCurPosition(MdmPositionRelationTerminalPageReqVo reqVo);

    /**
     * 绑定终端和职位
     *
     * @param terminalCodeList
     * @param positionCode
     */
    void bindRelation(List<String> terminalCodeList, String positionCode);

    /**
     * 替换终端绑定的职位
     *
     * @param ids
     * @param positionCode
     */
    void replaceTerminalPosition(List<String> ids, String positionCode);

    /**
     * 解除职位与终端的关联关系
     *
     * @param ids
     */
    void unbindRelation(List<String> ids);

}
