package com.biz.crm.position.service;


import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.position.model.MdmPositionRoleEntity;

import java.util.List;
import java.util.Map;

/**
 * 一个拥有权限信息的业务系统用户定义接口
 *
 * @author zxw
 * @date 2020-09-18 14:06:30
 */
public interface MdmPositionRoleService extends IService<MdmPositionRoleEntity> {

    /**
     * 根据职位编码查询角色编码
     *
     * @param positionCodeList 职位编码
     * @return list
     */
    List<String> findRoleCodeByPosition(List<String> positionCodeList);

    /**
     * 根据角色编码查询职位编码
     *
     * @param roleCodeList 角色编码
     * @return list
     */
    List<String> findPositionCodeCodeByRole(List<String> roleCodeList);

    void addRole(List<String> roleCodeList, String positionCode);

    void addPosition(List<String> positionCodeList, String roleCode);

    /**
     * 移除职位编码关联数据
     *
     * @param positionCode
     */
    void removePositionCode(String positionCode);

    /**
     * 批量移除职位编码关联数据
     *
     * @param positionCodes
     */
    void removePositionCodes(List<String> positionCodes);

    /**
     * 移除角色编码关联数据
     *
     * @param roleCode
     */
    void removeRoleCode(String roleCode);


    /**
     * 批量移除角色编码关联数据
     *
     * @param roleCodes
     */
    void removeRoleCodes(List<String> roleCodes);

    void removeRelation(List<String> ids);

    void removeRolePositions(String roleCode, List<String> positionCodeList);

    void replacePositionsRole(List<String> positionCodeList, String originRoleCode, String roleCode);

    /**
     * 查询角色编码关联的职位编码集合（去重）
     *
     * @param roleCodes
     * @return
     */
    List<String> getRoleRelationPositionCodeList(List<String> roleCodes);

    List<MdmRoleRespVo> getPositionRoleList(String positionCode);

    /**
     * 查询职位关联的角色编码,分组返回
     *
     * @param positionCodeList 职位编码集合
     * @return
     */
    Map<String, List<String>> getPositionRoleCodeGroupByPositionCodeList(List<String> positionCodeList);

    /**
     * 查询职位关联的角色,分组返回
     *
     * @param positionCodeList 职位编码集合
     * @return
     */
    Map<String, List<MdmRoleRespVo>> getPositionRoleGroupByPositionCodeList(List<String> positionCodeList);
}

