package com.biz.crm.position.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionPositionVo;
import com.biz.crm.nebular.mdm.position.req.*;
import com.biz.crm.nebular.mdm.position.resp.*;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.position.model.MdmPositionEntity;

import java.util.List;
import java.util.Set;

/**
 * 职位表接口
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
public interface MdmPositionService extends IService<MdmPositionEntity> {

    /**
     * 列表
     *
     * @param reqVo
     * @return PageResult<MdmPositionPageRespVo>
     */
    PageResult<MdmPositionPageRespVo> findList(MdmPositionPageReqVo reqVo);

    /**
     * 查询
     *
     * @param id
     * @param positionCode
     * @return MdmPositionRespVo
     */
    MdmPositionRespVo detail(String id, String positionCode);

    /**
     * 根据职位编码查询职位主表信息
     *
     * @param positionCode 职位编码
     * @return
     */
    MdmPositionRespVo queryByPositionCode(String positionCode);

    List<MdmPositionRespVo> queryBatchByPositionCodeList(List<String> positionCodeList);

    List<MdmPositionRespVo> queryBatchByOrgCodeList(List<String> orgCodeList);

    /**
     * 根据职位id或者职位编码查询职位主表，以及职位关联用户、组织、角色、流程角色，查询数据较多，请谨慎使用
     *
     * @param id
     * @param positionCode
     * @return
     */
    MdmPositionDetailRespVo getPositionDetail(String id, String positionCode);

    /**
     * 根据职位id集合或者职位编码集合批量查询职位及关联、用户、组织、上级职位信息，都传取交集
     *
     * @param ids
     * @param positionCodeList
     * @return
     */
    List<MdmPositionUserOrgRespVo> detailBatch(List<String> ids, List<String> positionCodeList);

    /**
     * 新增
     *
     * @param mdmPositionReqVo
     * @return
     */
    String save(MdmPositionReqVo mdmPositionReqVo);

    /**
     * 更新
     *
     * @param mdmPositionReqVo
     * @return
     */
    void update(MdmPositionReqVo mdmPositionReqVo);

    /**
     * 替换职位的上级职位
     *
     * @param positionCode
     * @param parentParentCode
     */
    void changePositionParent(String positionCode, String parentParentCode);

    /**
     * 更新主职位、组织、上级；其它地方不要调用这个接口，后续这里需要优化
     *
     * @param mdmPositionReqVo
     */
    @Deprecated
    void updateByPositionCode(MdmPositionReqVo mdmPositionReqVo);

    /**
     * 删除
     *
     * @param ids
     * @return
     */
    void deleteBatch(List<String> ids);

    /**
     * 启用
     *
     * @param ids
     * @return
     */
    void enableBatch(List<String> ids);

    /**
     * 禁用
     *
     * @param ids
     * @return
     */
    void disableBatch(List<String> ids);

    /**
     * 查询职位的全部上级职位
     *
     * @param id
     * @param positionCode
     * @return
     */
    List<MdmPositionRespVo> findAllParentPositionList(String id, String positionCode);

    List<String> findAllParentPositionCodeList(String id, String positionCode);

    /**
     * 查询职位的全部下级职位
     *
     * @param id
     * @param positionCode
     * @return
     */
    List<MdmPositionRespVo> findAllChildrenPositionList(String id, String positionCode);

    /**
     * 查询职位的全部下级职位编码
     *
     * @param id
     * @param positionCode
     * @return
     */
    List<String> findAllChildrenPositionCodeList(String id, String positionCode);

    /**
     * 获取职位的全部下级职位编码（不包含自己）
     *
     * @param id
     * @param positionCode
     * @return
     */
    List<String> findAllChildrenPositionCodeListExcludeSelf(String id, String positionCode);

    /**
     * 根据ids或者职位编码集合查询职位及全部下级职位集合
     *
     * @param ids
     * @param positionCodeList
     * @return
     */
    List<MdmPositionRespVo> findAllChildrenPositionListByList(List<String> ids, List<String> positionCodeList);

    /**
     * 查询职位的直接下级职位
     *
     * @param id
     * @param positionCode
     * @return
     */
    List<MdmPositionRespVo> findSingleChildrenPositionList(String id, String positionCode);

    /**
     * 查询职位下拉框
     *
     * @param reqVo
     * @return
     */
    List<MdmPositionSelectRespVo> findPositionSelectList(MdmPositionSelectReqVo reqVo);

    /**
     * 根据userName获取用户主职位
     *
     * @param reqVo
     * @return
     */
    MdmPositionRespVo getUserPrimaryPosition(MdmUserReqVo reqVo);

    MdmPositionUserOrgRespVo getPrimaryPositionByUserName(String userName);

    /**
     * 根据userName获取用户当前职位
     *
     * @param reqVo
     * @return
     */
    @Deprecated
    MdmPositionRespVo getUserCurrentPosition(MdmUserReqVo reqVo);

    /**
     * 根据登录名获取当前职位（职位全表）
     *
     * @param userName
     * @return
     */
    MdmPositionRespVo getUserCurrentPositionForLogin(String userName);

    /**
     * 根据登录名获取当前职位（职位全表及关联用户、组织、上级的主要字段）
     *
     * @param userName
     * @return
     */
    MdmPositionUserOrgRespVo getCurrentPositionByUserName(String userName);

    /**
     * 获取用户的所有职位
     *
     * @param reqVo
     * @return
     */
    @Deprecated
    List<MdmPositionRespVo> getUserAllPositionList(MdmUserReqVo reqVo);

    /**
     * 获取用户的所有职位
     *
     * @param userName 用户登录名
     * @return
     */
    List<MdmPositionRespVo> getUserAllPositionList(String userName);

    /**
     * 根据用户编码（userCode）获取用户全部职位
     *
     * @param userCode
     * @return
     */
    @Deprecated
    List<MdmPositionRespVo> getUserPositionByUserCode(String userCode);

    @Deprecated
    void changeUserPrimaryPosition(MdmPositionReqVo reqVo);

    /**
     * 切换用户主职位
     *
     * @param userName     用户登录名
     * @param positionCode 职位编码（用户已关联的）
     */
    void changeUserPrimaryPosition(String userName, String positionCode);

    @Deprecated
    void changeUserCurrentPosition(MdmPositionReqVo reqVo);

    /**
     * 切换用户当前职位
     *
     * @param userName     用户登录名
     * @param positionCode 职位编码（用户已关联的）
     */
    void changeUserCurrentPosition(String userName, String positionCode);

    /**
     * 查询以职位维度的职位及关联用户、组织、上级信息
     *
     * @param positionCode
     * @return
     */
    MdmPositionUserOrgRespVo getPositionUserOrgByPositionCode(String positionCode);

    /**
     * 查询以职位维度的职位及关联用户、组织、上级信息
     *
     * @param reqVo
     * @return
     */
    List<MdmPositionUserOrgRespVo> findPositionUserOrgList(MdmPositionUserOrgReqVo reqVo);

    /**
     * 查询以职位维度的职位及关联用户、组织、上级信息
     *
     * @param reqVo
     * @return
     */
    PageResult<MdmPositionUserOrgPageRespVo> findPositionUserOrgPageList(MdmPositionUserOrgPageReqVo reqVo);

    /**
     * 批量修改职位关联的组织编码
     *
     * @param reqVo
     */
    void batchUpdatePositionOrg(MdmPositionUserOrgReqVo reqVo);

    /**
     * 重置降维编码
     */
    void resetPositionRuleCode();

    /**
     * 根据流程角色编码查询职位，按照组织从指定组织向上寻址
     *
     * @param orgCode     组织编码
     * @param bpmRoleCode 流程角色编码
     * @return
     */
    List<MdmPositionUserOrgRespVo> findPositionListByBpmRoleStartUpByOrgCode(String orgCode, String bpmRoleCode);

    /**
     * 根据流程角色编码查询职位编码集合，按照组织及组织上级
     *
     * @param orgCode         组织编码（非必填）
     * @param bpmRoleCodeList 流程角色编码集合（必填）
     * @return
     */
    Set<String> findPositionCodeSetByOrgParentAndBpmRoleCodeList(String orgCode, List<String> bpmRoleCodeList);

    /**
     * 根据流程角色编码查询职位编码集合，按照组织
     *
     * @param orgCode         组织编码（非必填）
     * @param bpmRoleCodeList 流程角色编码集合（必填）
     * @return
     */
    Set<String> findPositionCodeSetByOrgAndBpmRoleCodeList(String orgCode, List<String> bpmRoleCodeList);

    /**
     * 查询职位对应的组织与用户
     *
     * @param positionCodeList
     * @return
     */
    List<MdmDataPermissionPositionVo> findPositionAndOrgList(List<String> positionCodeList);

    /**
     * 根据职位编码集合获取职位详情redis缓存数据
     *
     * @param orgCodeList 职位编码集合
     * @return
     */
    List<MdmPositionRedisVo> findRedisListByPositionCodeList(List<String> orgCodeList);

    /**
     * 根据职位编码集合获取职位上级redis缓存数据
     *
     * @param orgCodeList 职位编码集合
     * @return
     */
    List<MdmPositionParentChildrenRedisVo> findRedisPositionParentListByCodeList(List<String> orgCodeList);

    /**
     * 根据职位编码集合获取职位下级redis缓存数据
     *
     * @param orgCodeList 职位编码集合
     * @return
     */
    List<MdmPositionParentChildrenRedisVo> findRedisPositionChildrenListByCodeList(List<String> orgCodeList);

    /**
     * 获取全部职位redis缓存数据
     *
     * @return
     */
    List<MdmPositionReloadRedisVo> findRedisReloadList();

    /**
     * 职位与用户分页列表(SFA)
     * @param reqVo vo
     * @return page
     */
    PageResult<MdmPositionPageRespVo> positionAndUserPage(MdmPositionCurrentUserReqVo reqVo);

    /**
     * 根据当前用户类型查询职位与用户分页列表
     * @param reqVo vo
     * @return page
     */
    PageResult<MdmPositionPageRespVo> findPositionAndUserByType(MdmPositionCurrentUserReqVo reqVo);
}

