package com.biz.crm.position.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUnderlingParentSelectReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUnderlingReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUnderlingRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgPageRespVo;
import com.biz.crm.org.model.MdmOrgEntity;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.mapper.MdmPositionMapper;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.position.service.MdmPositionUnderlingService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.PageUtil;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.*;
import java.util.stream.Collectors;

@Service
public class MdmPositionUnderlingServiceImpl implements MdmPositionUnderlingService {

    @Resource
    private MdmPositionMapper mdmPositionMapper;

    @Resource
    private MdmPositionService mdmPositionService;

    @Resource
    private MdmOrgService mdmOrgService;

    @Override
    public PageResult<MdmPositionUnderlingRespVo> findPositionUnderlingList(MdmPositionUnderlingReqVo reqVo) {
        Assert.hasText(reqVo.getPositionCode(),"职位编码必传");
        Page<MdmPositionUnderlingRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<String> positionCodeList = Collections.singletonList(reqVo.getPositionCode());
        reqVo.setPositionCode(null);
        List<MdmPositionUnderlingRespVo> list = mdmPositionMapper.findPositionUnderlingList(page, reqVo, positionCodeList);
        return PageResult.<MdmPositionUnderlingRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void replaceParentPosition(MdmPositionUnderlingReqVo reqVo) {

        Assert.notEmpty(reqVo.getUnderlingPositionCodeList(), "请选择下级职位");
        Assert.hasText(reqVo.getPositionCode(), "请选择上级职位");
        MdmPositionEntity parentPosition = mdmPositionService.lambdaQuery().eq(MdmPositionEntity::getPositionCode, reqVo.getPositionCode()).one();
        Assert.notNull(parentPosition, "上级职位不存在");

        //查询所选上级职位的全部上级
        List<MdmPositionRespVo> parentList = mdmPositionService.findAllParentPositionList(parentPosition.getId(), null);
        List<String> parentCodeList = parentList.stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
        reqVo.getUnderlingPositionCodeList().forEach(positionCode -> {
            Assert.hasText(positionCode, "不能传空值");
            MdmPositionEntity position = mdmPositionService.lambdaQuery().eq(MdmPositionEntity::getPositionCode, positionCode).one();
            Assert.notNull(position, "无效的下级职位" + positionCode);
            Assert.isTrue(!parentCodeList.contains(positionCode), "所选职位" + parentPosition.getPositionName() + "是" + position.getPositionName() + "的下级职位，不能选择作为上级");
            mdmPositionService.changePositionParent(positionCode, reqVo.getPositionCode());
        });
    }

    @Override
    public PageResult<MdmPositionUserOrgPageRespVo> findPositionUnderlingParentSelectPageList(MdmPositionUnderlingParentSelectReqVo reqVo) {
        Assert.notEmpty(reqVo.getExcludeChildPositionCodeList(), "缺失下级职位");
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        Set<String> excludeOrgCodeList = new HashSet<>(16);
        List<MdmPositionRespVo> childrenPositionList = mdmPositionService.findAllChildrenPositionListByList(null, reqVo.getExcludeChildPositionCodeList());
        if (CollectionUtil.listNotEmptyNotSizeZero(childrenPositionList)) {
            Set<String> collect = childrenPositionList.stream().map(MdmPositionRespVo::getOrgCode).collect(Collectors.toSet());
            if (!collect.isEmpty()) {
                List<MdmOrgRespVo> childrenOrgList = mdmOrgService.findAllChildrenOrgListByList(null, new ArrayList<>(collect));
                Set<String> childrenCodeSet = childrenOrgList.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toSet());
                excludeOrgCodeList.addAll(childrenOrgList.stream().filter(item -> childrenCodeSet.contains(item.getParentCode())).map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList()));
            }
        }
        Page<MdmPositionUserOrgPageRespVo> page = PageUtil.buildPage(reqVo.getPageNum(), reqVo.getPageSize());
        List<MdmPositionUserOrgPageRespVo> list = mdmPositionMapper.findPositionUnderlingParentSelectPageList(page, reqVo, new ArrayList<>(excludeOrgCodeList));
        return PageResult.<MdmPositionUserOrgPageRespVo>builder()
                .data(list)
                .count(page.getTotal())
                .build();
    }

}
