package com.biz.crm.positionlevel.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.positionlevel.req.MdmPositionLevelReqVo;
import com.biz.crm.nebular.mdm.positionlevel.req.MdmPositionLevelSelectReqVo;
import com.biz.crm.nebular.mdm.positionlevel.resp.MdmPositionLevelRespVo;
import com.biz.crm.nebular.mdm.positionlevel.resp.MdmPositionLevelSelectRespVo;
import com.biz.crm.positionlevel.service.MdmPositionLevelService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 职位级别
 *
 * @author Tao.Chen
 * @date 2020-10-22 10:56:51
 */
@Slf4j
@RestController
@RequestMapping("/mdmPositionLevelController")
@Api(tags = "MDM-职位级别")
@CrmGlobalLog
public class MdmPositionLevelController {

    @Autowired
    private MdmPositionLevelService mdmPositionLevelService;

    @ApiOperation(value = "查询职位级别列表（分页）")
    @PostMapping("/pageList")
    @CrmDictMethod
    public Result<PageResult<MdmPositionLevelRespVo>> pageList(@RequestBody MdmPositionLevelReqVo mdmPositionLevelReqVo) {
        PageResult<MdmPositionLevelRespVo> result = mdmPositionLevelService.findList(mdmPositionLevelReqVo);
        return Result.ok(result);
    }


    @ApiOperation(value = "详情(编辑页面使用)", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "query")
    })
    @GetMapping("/queryForUpdate")
    @CrmDictMethod
    public Result<MdmPositionLevelRespVo> queryForUpdate(@RequestParam(value = "id", required = false) String id) {
        return Result.ok(mdmPositionLevelService.queryForUpdate(id));
    }

    @ApiOperation(value = "详情", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = false, dataType = "String", paramType = "query"),
            @ApiImplicitParam(name = "positionLevelCode", value = "职位级别编码", required = false, dataType = "String", paramType = "query")
    })
    @GetMapping("/detail")
    @CrmDictMethod
    public Result<MdmPositionLevelRespVo> detail(@RequestParam(value = "id", required = false) String id, @RequestParam(value = "positionLevelCode", required = false) String positionLevelCode) {
        return Result.ok(mdmPositionLevelService.detail(id, positionLevelCode));
    }

    @ApiOperation(value = "新增职位级别")
    @PostMapping("/save")
    public Result save(@RequestBody MdmPositionLevelReqVo mdmPositionLevelReqVo) {
        mdmPositionLevelService.save(mdmPositionLevelReqVo);
        return Result.ok();
    }

    @ApiOperation(value = "根据id更新职位级别")
    @PostMapping("/update")
    public Result update(@RequestBody MdmPositionLevelReqVo mdmPositionLevelReqVo) {
        mdmPositionLevelService.update(mdmPositionLevelReqVo);
        return Result.ok("修改成功");
    }

    @ApiOperation(value = "删除", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/delete")
    public Result delete(@RequestBody List<String> ids) {
        mdmPositionLevelService.deleteBatch(ids);
        return Result.ok("删除成功");
    }

    @ApiOperation(value = "启用", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/enable")
    public Result enable(@RequestBody List<String> ids) {
        mdmPositionLevelService.enableBatch(ids);
        return Result.ok("启用成功");
    }

    @ApiOperation(value = "禁用", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @PostMapping("/disable")
    public Result disable(@RequestBody List<String> ids) {
        mdmPositionLevelService.disableBatch(ids);
        return Result.ok("禁用成功");
    }

    @ApiOperation(value = "查询职位级别下拉框选择数据")
    @PostMapping("/selectList")
    public Result<List<MdmPositionLevelSelectRespVo>> selectList(@RequestBody MdmPositionLevelSelectReqVo reqVo) {
        List<MdmPositionLevelSelectRespVo> result = mdmPositionLevelService.selectList(reqVo);
        return Result.ok(result);
    }

}
