package com.biz.crm.positionlevel.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.interceptor.SqlPrivilege;
import com.biz.crm.nebular.mdm.position.req.MdmPositionReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.positionlevel.req.MdmPositionLevelReqVo;
import com.biz.crm.nebular.mdm.positionlevel.req.MdmPositionLevelSelectReqVo;
import com.biz.crm.nebular.mdm.positionlevel.resp.MdmPositionLevelRespVo;
import com.biz.crm.nebular.mdm.positionlevel.resp.MdmPositionLevelSelectRespVo;
import com.biz.crm.positionlevel.model.MdmPositionLevelEntity;
import com.biz.crm.positionlevel.provider.MdmPositionLevelProvider;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.SelectProvider;

import java.util.List;

/**
 * 职位级别
 *
 * @author Tao.Chen
 * @date 2020-10-22 10:56:51
 */
public interface MdmPositionLevelMapper extends BaseMapper<MdmPositionLevelEntity> {

    /**
     * 列表
     *
     * @param page
     * @param mdmPositionLevelReqVo
     * @return
     */
    @SqlPrivilege(
            extPosSql = "select 1 from mdm_position where position_level_code=a.position_level_code and position_code in",
            extOrgSql = "select 1 from mdm_position where position_level_code=a.position_level_code and ORG_CODE in"
    )
    List<MdmPositionLevelRespVo> findList(Page<MdmPositionLevelRespVo> page, @Param("vo") MdmPositionLevelReqVo mdmPositionLevelReqVo);


    /**
     * 列表(provider)
     *
     * @param page
     * @param mdmPositionLevelReqVo
     * @return
     */
    @SelectProvider(type = MdmPositionLevelProvider.class,method = "findListProvider")
    List<MdmPositionLevelRespVo> findListProvider(Page<MdmPositionLevelRespVo> page, @Param("vo") MdmPositionLevelReqVo mdmPositionLevelReqVo);



    /**
     * 查询职位级别对应职位信息（分页）
     *
     * @param page
     * @param reqVo
     * @return
     */
    @SqlPrivilege(posCode = "b1.position_code",orgCode = "b1.org_code")
    List<MdmPositionRespVo> positionList(Page<MdmPositionRespVo> page, @Param("vo") MdmPositionReqVo reqVo);

    /**
     * 职位级别下拉框
     *
     * @param page        分页参数
     * @param reqVo       筛选条件
     * @return
     */
    @SqlPrivilege(
            extPosSql = "select 1 from mdm_position where position_level_code=a.position_level_code and position_code in",
            extOrgSql = "select 1 from mdm_position where position_level_code=a.position_level_code and ORG_CODE in"
    )
    List<MdmPositionLevelSelectRespVo> positionLevelSelectList(Page<MdmPositionLevelSelectRespVo> page, @Param("vo") MdmPositionLevelSelectReqVo reqVo);


    /**
     * 检查唯一性
     * @param posLevelName
     * @return
     */
    String queryPositionLevelNameOnlyOne(String posLevelName);

}
