package com.biz.crm.positionlevel.provider;

import com.biz.crm.eunm.mdm.MdmProviderEnum;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.nebular.mdm.positionlevel.req.MdmPositionLevelReqVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.ProviderUtil;
import org.apache.ibatis.jdbc.SQL;

import java.util.List;
import java.util.Map;

/**
 * @Author hej
 * @Created Date 2021-01-07 13:53
 **/
public class MdmPositionLevelProvider {

    public String findListProvider(Map<String,Object> map){
        MdmPositionLevelReqVo vo = (MdmPositionLevelReqVo) map.get("vo");
        List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL(){{
            SELECT("*");
            FROM("mdm_position_level a");
            if(CollectionUtil.listNotEmptyNotSizeZero(vo.getIds())){
                WHERE("a.id in " + ProviderUtil.gainForeach("(",",",")",vo.getIds()));
            }
            if(StringUtils.isNotEmpty(vo.getEnableStatus())){
                WHERE("a.enable_status = #{vo.enableStatus}");
            }
            if(StringUtils.isNotEmpty(vo.getId())){
                WHERE("a.id = #{vo.id}");
            }
            if(StringUtils.isNotEmpty(vo.getPositionLevelCode())){
                WHERE("a.position_level_code like "+ProviderUtil.bindPercent(vo.getPositionLevelCode(), MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getPositionLevelName())){
                WHERE("a.position_level_name like "+ProviderUtil.bindPercent(vo.getPositionLevelName(),MdmProviderEnum.SQL_JOIN_ALL));
            }
            if(StringUtils.isNotEmpty(vo.getRoleName())){
                WHERE("a.position_level_code in " +
                        "(select distinct t1.position_level_code from mdm_position_level_role t1 " +
                        "left join mdm_role t2 on t1.role_code = t2.role_code" +
                        "where t2.role_name like " +ProviderUtil.bindPercent(vo.getRoleName(),MdmProviderEnum.SQL_JOIN_ALL) +")");
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(cvo)) {
                WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
            }
            ORDER_BY("position_level_code desc");

        }}.toString();
    }

}
