package com.biz.crm.positionlevel.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.positionlevel.model.MdmPositionLevelRoleEntity;

import java.util.List;

/**
 * 职位级别-角色关联表接口
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
public interface MdmPositionLevelRoleService extends IService<MdmPositionLevelRoleEntity> {

    /**
     * 替换职位级别关联的角色
     *
     * @param positionLevelCode
     * @param roleCodes
     */
    void replacePositionLevelRole(String positionLevelCode, List<String> roleCodes);

    /**
     * 添加职位级别关联的角色
     *
     * @param positionLevelCode
     * @param roleCodes
     */
    void addPositionLevelRole(String positionLevelCode, List<String> roleCodes);

    /**
     * 移除职位级别关联的角色
     *
     * @param positionLevelCode
     */
    void removePositionLevel(String positionLevelCode);

    /**
     * 批量移除职位级别关联的角色
     *
     * @param positionLevelCodes
     */
    void removePositionLevels(List<String> positionLevelCodes);

    /**
     * 移除角色编码关联职位级别
     *
     * @param roleCode
     */
    void removeRoleCode(String roleCode);

    /**
     * 批量移除角色编码关联职位级别
     *
     * @param roleCodes
     */
    void removeRoleCodes(List<String> roleCodes);
}

