package com.biz.crm.positionlevel.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.positionlevel.mapper.MdmPositionLevelRoleMapper;
import com.biz.crm.positionlevel.model.MdmPositionLevelRoleEntity;
import com.biz.crm.positionlevel.service.MdmPositionLevelRoleService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 职位级别-角色关联表接口实现
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Slf4j
@Service
@ConditionalOnMissingBean(name = "MdmPositionLevelRoleServiceExpandImpl")
@Transactional(rollbackFor = Exception.class)
public class MdmPositionLevelRoleServiceImpl<M extends BaseMapper<T>, T> extends ServiceImpl<MdmPositionLevelRoleMapper, MdmPositionLevelRoleEntity> implements MdmPositionLevelRoleService {

    @Resource
    private MdmPositionLevelRoleMapper mdmPositionLevelRoleMapper;

    @Override
    public void replacePositionLevelRole(String positionLevelCode, List<String> roleCodes) {
        if (StringUtils.isNotEmpty(positionLevelCode)) {
            this.removePositionLevel(positionLevelCode);
            if (CollectionUtil.listNotEmptyNotSizeZero(roleCodes)) {
                roleCodes.stream().filter(StringUtils::isNotEmpty).forEach(roleCode -> {
                    MdmPositionLevelRoleEntity entity = new MdmPositionLevelRoleEntity();
                    entity.setPositionLevelCode(positionLevelCode);
                    entity.setRoleCode(roleCode);
                    this.save(entity);
                });
            }
        }
    }

    @Override
    public void addPositionLevelRole(String positionLevelCode, List<String> roleCodes) {
        if (StringUtils.isNotEmpty(positionLevelCode)) {
            if (CollectionUtil.listNotEmptyNotSizeZero(roleCodes)) {
                List<String> collect = roleCodes.stream().filter(StringUtils::isNotEmpty).collect(Collectors.toList());
                if (CollectionUtil.listNotEmptyNotSizeZero(collect)) {
                    final Set<String> exist = this.lambdaQuery()
                            .eq(MdmPositionLevelRoleEntity::getPositionLevelCode, positionLevelCode)
                            .in(MdmPositionLevelRoleEntity::getRoleCode, collect)
                            .select(MdmPositionLevelRoleEntity::getRoleCode)
                            .list()
                            .stream().map(MdmPositionLevelRoleEntity::getRoleCode).collect(Collectors.toSet());
                    collect.stream().filter(x -> !exist.contains(x)).forEach(roleCode -> {
                        MdmPositionLevelRoleEntity entity = new MdmPositionLevelRoleEntity();
                        entity.setPositionLevelCode(positionLevelCode);
                        entity.setRoleCode(roleCode);
                        this.save(entity);
                    });
                }
            }
        }
    }

    @Override
    public void removePositionLevel(String positionLevelCode) {
        if (StringUtils.isNotEmpty(positionLevelCode)) {
            this.removePositionLevels(Collections.singletonList(positionLevelCode));
        }
    }

    @Override
    public void removePositionLevels(List<String> positionLevelCodes) {
        if (CollectionUtil.listNotEmptyNotSizeZero(positionLevelCodes)) {
            this.lambdaUpdate()
                    .in(MdmPositionLevelRoleEntity::getPositionLevelCode, positionLevelCodes)
                    .remove();
        }
    }

    @Override
    public void removeRoleCode(String roleCode) {
        if (StringUtils.isNotEmpty(roleCode)) {
            this.removeRoleCodes(Collections.singletonList(roleCode));
        }
    }

    @Override
    public void removeRoleCodes(List<String> roleCodes) {
        if (CollectionUtil.listNotEmptyNotSizeZero(roleCodes)) {
            this.lambdaUpdate()
                    .in(MdmPositionLevelRoleEntity::getRoleCode, roleCodes)
                    .remove();
        }
    }
}
